/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import com.google.common.reflect.TypeToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import org.spf4j.base.Invocation;
import org.spf4j.jmx.ExportedOperation;
import org.spf4j.jmx.GlobalMXBeanMapperSupplier;
import org.spf4j.jmx.JMXBeanMapping;

public final class GenericExportedOperation
implements ExportedOperation {
    private final String name;
    private final String description;
    private final Invocation invocation;
    private final MBeanParameterInfo[] paramInfos;
    private final JMXBeanMapping[] argConverters;
    private final JMXBeanMapping resultConverter;
    private final Type returnType;

    public GenericExportedOperation(String name, String description, Invocation invocation, Type[] parameterTypes, Type returnType, String[] parameterNames, String[] parameterDescriptions, boolean[] mapOpenTypeParam, boolean mapOpenType) {
        this.name = name;
        this.description = description;
        this.invocation = invocation;
        this.returnType = returnType;
        if (mapOpenType) {
            try {
                this.resultConverter = GlobalMXBeanMapperSupplier.getOpenTypeMapping(returnType);
            }
            catch (NotSerializableException ex) {
                throw new UnsupportedOperationException("Cannot export " + name + " returned type " + returnType + "  not serializable", ex);
            }
        } else {
            this.resultConverter = null;
        }
        this.argConverters = new JMXBeanMapping[parameterTypes.length];
        this.paramInfos = new MBeanParameterInfo[parameterTypes.length];
        for (int i = 0; i < this.paramInfos.length; ++i) {
            JMXBeanMapping paramOTM;
            String pname = parameterNames[i];
            String pdesc = parameterDescriptions[i];
            boolean mapParamOpenType = mapOpenTypeParam[i];
            if ("".equals(pname)) {
                pname = "param_" + i;
            }
            if (pdesc.isEmpty()) {
                pdesc = name;
            }
            Type parameterType = parameterTypes[i];
            if (mapParamOpenType) {
                try {
                    paramOTM = GlobalMXBeanMapperSupplier.getOpenTypeMapping(parameterType);
                }
                catch (NotSerializableException ex) {
                    throw new UnsupportedOperationException("Cannot export " + name + " arg " + i + " not serializable from " + Arrays.toString(parameterTypes), ex);
                }
            } else {
                paramOTM = null;
            }
            if (paramOTM != null) {
                this.paramInfos[i] = new OpenMBeanParameterInfoSupport(pname, pdesc, paramOTM.getOpenType());
                this.argConverters[i] = paramOTM;
                continue;
            }
            this.paramInfos[i] = new MBeanParameterInfo(pname, parameterType.getTypeName(), pdesc);
            this.argConverters[i] = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object invoke(Object[] parameters) throws OpenDataException, InvalidObjectException {
        for (int i = 0; i < parameters.length; ++i) {
            JMXBeanMapping argConverter = this.argConverters[i];
            if (argConverter == null) continue;
            parameters[i] = argConverter.fromOpenValue(parameters[i]);
        }
        try {
            Object rVal = this.invocation.invoke(parameters);
            if (this.resultConverter != null) {
                return this.resultConverter.toOpenValue(rVal);
            }
            return rVal;
        }
        catch (Exception ex) {
            OpenDataException x = new OpenDataException("Cannot invoke " + this.invocation + " with " + Arrays.toString(parameters));
            x.addSuppressed(ex);
            throw x;
        }
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public MBeanParameterInfo[] getParameterInfos() {
        return this.paramInfos;
    }

    @Override
    public Class<?> getReturnType() {
        return TypeToken.of((Type)this.returnType).getRawType();
    }

    @Override
    @Nullable
    public OpenType<?> getReturnOpenType() {
        return this.resultConverter != null ? this.resultConverter.getOpenType() : null;
    }

    public String toString() {
        return "GenericExportedOperation{name=" + this.name + ", description=" + this.description + ", invocation=" + this.invocation + ", paramInfos=" + Arrays.toString(this.paramInfos) + ", argConverters=" + Arrays.toString(this.argConverters) + ", resultConverter=" + this.resultConverter + ", returnType=" + this.returnType + '}';
    }
}

