/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.spf4j.base.UncheckedExecutionException;
import org.spf4j.jmx.ExportedValue;
import org.spf4j.jmx.GlobalMXBeanMapperSupplier;
import org.spf4j.jmx.JMXBeanMapping;

public final class GenericExportedValue<T>
implements ExportedValue {
    private final String name;
    private final String description;
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private final Class<T> clasz;
    private final JMXBeanMapping converter;
    private final OpenType<?> openType;

    public GenericExportedValue(@Nonnull String name, @Nonnull String description, @Nonnull Supplier<T> getter, @Nullable Consumer<T> setter, Class<T> clasz) throws NotSerializableException {
        this.description = description;
        this.name = name;
        this.getter = getter;
        this.setter = setter;
        this.clasz = clasz;
        this.converter = GlobalMXBeanMapperSupplier.getOpenTypeMapping(clasz);
        this.openType = this.converter == null ? null : this.converter.getOpenType();
    }

    public GenericExportedValue(@Nonnull String name, @Nonnull String description, @Nonnull Supplier<CompositeData> getter, @Nullable Consumer<CompositeData> setter, CompositeType openType) {
        this.description = description;
        this.name = name;
        this.getter = getter;
        this.setter = setter;
        this.clasz = CompositeData.class;
        this.converter = null;
        this.openType = openType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Object get() throws OpenDataException {
        T val = this.getter.get();
        if (this.converter == null) {
            return val;
        }
        return this.converter.toOpenValue(val);
    }

    public void set(Object value) throws InvalidObjectException {
        if (this.converter == null) {
            this.setter.accept(value);
        } else {
            this.setter.accept(this.converter.fromOpenValue(value));
        }
    }

    @Override
    public boolean isWriteable() {
        return this.setter != null;
    }

    @Override
    public Class getValueType() {
        return this.clasz;
    }

    public String toString() {
        try {
            return "GenericExportedValue{val=" + this.get() + "valClass=" + this.getValueType() + "valopenType=" + this.getValueOpenType() + ", description=" + this.getDescription() + ", name=" + this.name + ", converter=" + this.converter + '}';
        }
        catch (OpenDataException ex) {
            throw new UncheckedExecutionException(ex);
        }
    }

    public OpenType getValueOpenType() {
        return this.openType;
    }
}

