/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.spf4j.jmx.ExportedValue;
import org.spf4j.jmx.GlobalMXBeanMapperSupplier;
import org.spf4j.jmx.JMXBeanMapping;

final class MapExportedValue
implements ExportedValue {
    private final Map<String, Object> map;
    private final Map<String, String> descriptions;
    private final String name;
    private final JMXBeanMapping converter;

    MapExportedValue(Map<String, Object> map, Map<String, String> descriptions, String name, @Nullable Object value) throws NotSerializableException {
        this.map = map;
        this.descriptions = descriptions;
        this.name = name;
        this.converter = value == null ? null : GlobalMXBeanMapperSupplier.getOpenTypeMapping(value.getClass());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        if (this.descriptions != null) {
            return this.descriptions.get(this.name);
        }
        return "";
    }

    public Object get() throws OpenDataException {
        Object val = this.map.get(this.name);
        if (this.converter == null) {
            return val;
        }
        return this.converter.toOpenValue(val);
    }

    public void set(Object value) throws InvalidObjectException {
        if (this.converter == null) {
            this.map.put(this.name, value);
        } else {
            this.map.put(this.name, this.converter.fromOpenValue(value));
        }
    }

    @Override
    public boolean isWriteable() {
        return true;
    }

    @Override
    public Class getValueType() {
        Object obj = this.map.get(this.name);
        if (obj == null) {
            return String.class;
        }
        return obj.getClass();
    }

    public String toString() {
        try {
            return "MapExportedValue{val=" + this.get() + "valClass=" + this.getValueType() + "valopenType=" + this.getValueOpenType() + ", description=" + this.getDescription() + ", name=" + this.name + ", converter=" + this.converter + '}';
        }
        catch (OpenDataException ex) {
            throw new UncheckedExecutionException((Throwable)ex);
        }
    }

    @Nullable
    public OpenType getValueOpenType() {
        return this.converter != null ? this.converter.getOpenType() : null;
    }
}

