/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx.mappers;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.sun.jmx.mbeanserver.MXBeanMapping;
import com.sun.jmx.mbeanserver.MXBeanMappingFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.spf4j.base.Throwables;
import org.spf4j.jmx.JMXBeanMapping;
import org.spf4j.jmx.JMXBeanMappingSupplier;
import org.spf4j.jmx.mappers.MXBeanMappings;

abstract class Spf4jJMXBeanMapping
implements JMXBeanMapping {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String[] MAP_INDEX_NAMES = new String[]{"key"};
    private static final String[] MAP_ITEM_NAMES = new String[]{"key", "value"};
    private static final Type[] STR_STR_TYPES = new Type[]{String.class, String.class};
    protected OpenType<?> openType;
    protected Class<?> mappedTypeClass;

    Spf4jJMXBeanMapping() {
        this(null, null);
    }

    Spf4jJMXBeanMapping(OpenType<?> openType, Class<?> mappedTypeClass) {
        this.openType = openType;
        this.mappedTypeClass = mappedTypeClass;
    }

    @SuppressFBWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"})
    public static JMXBeanMapping defaultHandler(Type javaType, final JMXBeanMappingSupplier mappings) throws NotSerializableException {
        try {
            MXBeanMapping mapping = MXBeanMappingFactory.DEFAULT.mappingForType(javaType, new MXBeanMappingFactory(){

                @Override
                public MXBeanMapping mappingForType(Type t, MXBeanMappingFactory f) throws OpenDataException {
                    JMXBeanMapping m;
                    try {
                        m = mappings.get(t);
                    }
                    catch (NotSerializableException ex) {
                        OpenDataException tex = new OpenDataException(t + " is not seriablizable ");
                        tex.initCause(ex);
                        throw tex;
                    }
                    if (m != null) {
                        return MXBeanMappings.convert(m);
                    }
                    return MXBeanMappingFactory.DEFAULT.mappingForType(t, f);
                }
            });
            return MXBeanMappings.convert(mapping);
        }
        catch (OpenDataException ex) {
            NotSerializableException nsex = Throwables.first((Throwable)ex, NotSerializableException.class);
            if (nsex != null) {
                throw nsex;
            }
            throw new IllegalArgumentException("No type mapping for " + javaType, ex);
        }
    }

    @Override
    public OpenType<?> getOpenType() {
        return this.openType;
    }

    @Override
    public Class<?> getMappedType() {
        return this.mappedTypeClass;
    }

    static class MapMXBeanType
    extends Spf4jJMXBeanMapping {
        private final Type javaType;
        private final Class<?> rawType;
        private final JMXBeanMapping keyType;
        private final JMXBeanMapping valueType;

        @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX", "ITC_INHERITANCE_TYPE_CHECKING"})
        MapMXBeanType(Type pt, JMXBeanMappingSupplier mappings) throws NotSerializableException {
            try {
                Type[] argTypes;
                this.javaType = pt;
                if (pt instanceof ParameterizedType) {
                    argTypes = ((ParameterizedType)pt).getActualTypeArguments();
                    this.rawType = (Class)((ParameterizedType)pt).getRawType();
                } else if (pt instanceof Class && Properties.class.isAssignableFrom((Class)pt)) {
                    argTypes = STR_STR_TYPES;
                    this.rawType = (Class)pt;
                } else {
                    throw new IllegalArgumentException("Unsupported type " + pt);
                }
                assert (argTypes.length == 2);
                this.keyType = mappings.get(argTypes[0]);
                if (this.keyType == null) {
                    throw new IllegalArgumentException("Key of " + pt + " cannot be converted to open type");
                }
                this.valueType = mappings.get(argTypes[1]);
                if (this.valueType == null) {
                    throw new IllegalArgumentException("Value of " + pt + " cannot be converted to open type");
                }
                String typeName = pt.getTypeName();
                OpenType[] mapItemTypes = new OpenType[]{this.keyType.getOpenType(), this.valueType.getOpenType()};
                CompositeType rowType = new CompositeType(typeName, typeName, MAP_ITEM_NAMES, MAP_ITEM_NAMES, mapItemTypes);
                this.openType = new TabularType(typeName, typeName, rowType, MAP_INDEX_NAMES);
                this.mappedTypeClass = TabularData.class;
            }
            catch (OpenDataException ex) {
                throw new IllegalArgumentException("Unsupported type " + pt, ex);
            }
        }

        @Override
        public Type getJavaType() {
            return this.javaType;
        }

        @Override
        public Object toOpenValue(Object data) throws OpenDataException {
            Map map = (Map)data;
            TabularType tabularType = (TabularType)this.openType;
            TabularDataSupport table = new TabularDataSupport(tabularType);
            CompositeType rowType = tabularType.getRowType();
            for (Map.Entry entry : map.entrySet()) {
                Object key = this.keyType.toOpenValue(entry.getKey());
                Object value = this.valueType.toOpenValue(entry.getValue());
                CompositeDataSupport row = new CompositeDataSupport(rowType, MAP_ITEM_NAMES, new Object[]{key, value});
                table.put(row);
            }
            return table;
        }

        @Override
        public Object fromOpenValue(Object data) throws InvalidObjectException {
            Map<Object, Object> result;
            TabularData td = (TabularData)data;
            if (this.rawType.isInterface()) {
                result = Maps.newHashMapWithExpectedSize((int)td.values().size());
            } else {
                try {
                    result = (Map)this.rawType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    InvalidObjectException iox = new InvalidObjectException("Cannot instantiate " + this.rawType);
                    iox.addSuppressed(ex);
                    throw iox;
                }
            }
            for (CompositeData row : td.values()) {
                Object key = this.keyType.fromOpenValue(row.get(Spf4jJMXBeanMapping.KEY));
                Object value = this.valueType.fromOpenValue(row.get(Spf4jJMXBeanMapping.VALUE));
                result.put(key, value);
            }
            return result;
        }
    }

    static class ListMXBeanType
    extends Spf4jJMXBeanMapping {
        private final ParameterizedType javaType;
        private final JMXBeanMapping paramMapping;
        private final Class<?> rawType;

        ListMXBeanType(ParameterizedType pt, JMXBeanMappingSupplier mappings) throws NotSerializableException {
            this.javaType = pt;
            this.rawType = (Class)pt.getRawType();
            Type[] argTypes = pt.getActualTypeArguments();
            assert (argTypes.length == 1);
            Type argType = argTypes[0];
            TypeToken tt = TypeToken.of((Type)argType);
            Class et = tt.getRawType();
            if (et.isArray()) {
                throw new IllegalArgumentException("Element Type for " + pt + " not supported");
            }
            this.paramMapping = mappings.get(argType);
            String cname = "[L" + this.paramMapping.getMappedType().getName() + ";";
            try {
                this.mappedTypeClass = Class.forName(cname);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Array class not found " + cname, e);
            }
            try {
                this.openType = new ArrayType(1, this.paramMapping.getOpenType());
            }
            catch (OpenDataException ex) {
                throw new IllegalArgumentException("Invalid arg " + pt, ex);
            }
        }

        @Override
        public Type getJavaType() {
            return this.javaType;
        }

        @Override
        public Object toOpenValue(Object data) throws OpenDataException {
            if (data instanceof Collection) {
                Collection list = (Collection)data;
                Object[] openArray = (Object[])Array.newInstance(this.paramMapping.getMappedType(), list.size());
                int i = 0;
                for (Object o : list) {
                    openArray[i++] = this.paramMapping.toOpenValue(o);
                }
                return openArray;
            }
            Iterable list = (Iterable)data;
            ArrayList<Object> result = new ArrayList<Object>(16);
            for (Object o : list) {
                result.add(this.paramMapping.toOpenValue(o));
            }
            return result.toArray((Object[])Array.newInstance(this.paramMapping.getMappedType(), result.size()));
        }

        @Override
        public Object fromOpenValue(Object data) throws InvalidObjectException {
            AbstractCollection result;
            Object[] openArray = (Object[])data;
            if (this.rawType.isInterface()) {
                result = Set.class == this.rawType ? new HashSet(openArray.length) : (Deque.class == this.rawType ? new ArrayDeque(openArray.length) : new ArrayList(openArray.length));
            } else {
                try {
                    result = (HashSet)this.rawType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    InvalidObjectException iox = new InvalidObjectException("Cannot instantiate " + this.rawType);
                    iox.addSuppressed(ex);
                    throw iox;
                }
            }
            for (Object o : openArray) {
                result.add(this.paramMapping.fromOpenValue(o));
            }
            return result;
        }
    }

    static class GenericArrayMXBeanType
    extends ArrayMXBeanType {
        private final GenericArrayType gtype;

        GenericArrayMXBeanType(GenericArrayType gat, JMXBeanMappingSupplier mappings) throws NotSerializableException {
            this.gtype = gat;
            this.componentType = mappings.get(gat.getGenericComponentType());
            StringBuilder className = new StringBuilder();
            Type elementType = gat;
            int dim = 0;
            while (elementType instanceof GenericArrayType) {
                className.append('[');
                GenericArrayType et = elementType;
                elementType = et.getGenericComponentType();
                ++dim;
            }
            this.baseElementType = mappings.get(elementType);
            if (elementType instanceof Class && ((Class)elementType).isPrimitive()) {
                className = new StringBuilder(gat.toString());
            } else {
                className.append('L').append(this.baseElementType.getMappedType().getTypeName()).append(';');
            }
            try {
                this.mappedTypeClass = Class.forName(className.toString());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot obtain array class " + className, e);
            }
            try {
                this.openType = new ArrayType(dim, this.baseElementType.getOpenType());
            }
            catch (OpenDataException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public Type getJavaType() {
            return this.gtype;
        }
    }

    static class ArrayMXBeanType
    extends Spf4jJMXBeanMapping {
        private final Class<?> arrayClass;
        protected JMXBeanMapping componentType;
        protected JMXBeanMapping baseElementType;

        ArrayMXBeanType(Class<?> c, JMXBeanMappingSupplier mappings) throws NotSerializableException {
            this.arrayClass = c;
            this.componentType = mappings.get(c.getComponentType());
            StringBuilder className = new StringBuilder();
            Class<?> et = c;
            int dim = 0;
            while (et.isArray()) {
                className.append('[');
                et = et.getComponentType();
                ++dim;
            }
            this.baseElementType = mappings.get(et);
            if (et.isPrimitive()) {
                className = new StringBuilder(c.getName());
            } else {
                className.append('L').append(this.baseElementType.getMappedType().getTypeName()).append(';');
            }
            try {
                this.mappedTypeClass = Class.forName(className.toString());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot obtain array class " + className, e);
            }
            try {
                this.openType = new ArrayType(dim, this.baseElementType.getOpenType());
            }
            catch (OpenDataException ex) {
                throw new IllegalArgumentException("Unsupported type " + c, ex);
            }
        }

        protected ArrayMXBeanType() {
            this.arrayClass = null;
        }

        @Override
        public Type getJavaType() {
            return this.arrayClass;
        }

        @Override
        @SuppressFBWarnings(value={"URV_INHERITED_METHOD_WITH_RELATED_TYPES"})
        public Object toOpenValue(Object data) throws OpenDataException {
            if (this.baseElementType.isSimpleType()) {
                return data;
            }
            Object[] array = (Object[])data;
            Object[] openArray = (Object[])Array.newInstance(this.componentType.getMappedType(), array.length);
            int i = 0;
            for (Object o : array) {
                openArray[i] = o == null ? null : this.componentType.toOpenValue(o);
                ++i;
            }
            return openArray;
        }

        @Override
        @SuppressFBWarnings(value={"URV_INHERITED_METHOD_WITH_RELATED_TYPES"})
        public Object fromOpenValue(Object data) throws InvalidObjectException {
            if (this.baseElementType.isSimpleType()) {
                return data;
            }
            Object[] openArray = (Object[])data;
            Object[] array = (Object[])Array.newInstance((Class)this.componentType.getJavaType(), openArray.length);
            int i = 0;
            for (Object o : openArray) {
                array[i] = o == null ? null : this.componentType.fromOpenValue(o);
                ++i;
            }
            return array;
        }
    }

    static class EnumMXBeanType
    extends Spf4jJMXBeanMapping {
        private final Class enumClass;

        EnumMXBeanType(Class<?> c) {
            super(SimpleType.STRING, String.class);
            this.enumClass = c;
        }

        @Override
        public Type getJavaType() {
            return this.enumClass;
        }

        @Override
        public Object toOpenValue(Object data) {
            return ((Enum)data).name();
        }

        @Override
        public Object fromOpenValue(Object data) throws InvalidObjectException {
            try {
                return Enum.valueOf(this.enumClass, (String)data);
            }
            catch (IllegalArgumentException e) {
                InvalidObjectException ioe = new InvalidObjectException("Enum constant named " + (String)data + " is missing");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    static class BasicMXBeanType
    extends Spf4jJMXBeanMapping {
        BasicMXBeanType(Class<?> c, OpenType<?> openType) {
            super(openType, c);
        }

        @Override
        public Type getJavaType() {
            return this.getMappedType();
        }

        @Override
        public Object toOpenValue(Object data) {
            return data;
        }

        @Override
        public Object fromOpenValue(Object data) {
            return data;
        }
    }
}

