/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx.mappers;

import com.google.common.reflect.TypeToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.management.ObjectName;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.avro.specific.SpecificRecordBase;
import org.spf4j.base.Pair;
import org.spf4j.jmx.JMXBeanMapping;
import org.spf4j.jmx.JMXBeanMappingSupplier;
import org.spf4j.jmx.mappers.MapEntryOpenTypeMapping;
import org.spf4j.jmx.mappers.SpecificRecordOpenTypeMapping;
import org.spf4j.jmx.mappers.Spf4jJMXBeanMapping;
import org.spf4j.reflect.CachingTypeMapSupplierWrapper;
import org.spf4j.reflect.GraphTypeMap;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public final class Spf4jOpenTypeMapper
implements JMXBeanMappingSupplier {
    private static final Logger LOG = Logger.getLogger(Spf4jOpenTypeMapper.class.getName());
    private static final ThreadLocal<Set<Type>> IN_PROGRESS = new ThreadLocal<Set<Type>>(){

        @Override
        protected Set<Type> initialValue() {
            return new HashSet<Type>(2);
        }
    };
    private static final Pair<OpenType<?>, Class<?>[]>[] SIMPLE_TYPES = new Pair[]{Pair.of(SimpleType.BIGDECIMAL, new Class[]{BigDecimal.class}), Pair.of(SimpleType.BIGINTEGER, new Class[]{BigInteger.class}), Pair.of(SimpleType.BOOLEAN, new Class[]{Boolean.class, Boolean.TYPE}), Pair.of(SimpleType.BYTE, new Class[]{Byte.class, Byte.TYPE}), Pair.of(SimpleType.CHARACTER, new Class[]{Character.class, Character.TYPE}), Pair.of(SimpleType.DATE, new Class[]{Date.class}), Pair.of(SimpleType.DOUBLE, new Class[]{Double.class, Double.TYPE}), Pair.of(SimpleType.FLOAT, new Class[]{Float.class, Float.TYPE}), Pair.of(SimpleType.INTEGER, new Class[]{Integer.class, Integer.TYPE}), Pair.of(SimpleType.LONG, new Class[]{Long.class, Long.TYPE}), Pair.of(SimpleType.SHORT, new Class[]{Short.class, Short.TYPE}), Pair.of(SimpleType.OBJECTNAME, new Class[]{ObjectName.class}), Pair.of(SimpleType.STRING, new Class[]{String.class}), Pair.of(SimpleType.VOID, new Class[]{Void.class})};
    private final CachingTypeMapSupplierWrapper<JMXBeanMapping, NotSerializableException> cache = new CachingTypeMapSupplierWrapper(new GraphTypeMap(), NotSerializableException.class);

    public Spf4jOpenTypeMapper() {
        for (Pair<OpenType<?>, Class<?>[]> t : SIMPLE_TYPES) {
            for (Class<?> c : t.getSecond()) {
                this.cache.safePut(c, type -> new Spf4jJMXBeanMapping.BasicMXBeanType(c, (OpenType)t.getFirst()));
            }
        }
        this.cache.safePut((Type)((Object)Enum.class), type -> new Spf4jJMXBeanMapping.EnumMXBeanType((Class)type));
        this.cache.safePut((Type)((Object)SpecificRecordBase.class), type -> new SpecificRecordOpenTypeMapping((Class)type, this));
        this.cache.safePut((Type)((Object)Properties.class), type -> new Spf4jJMXBeanMapping.MapMXBeanType((Class)type, this));
        this.cache.safePut((Type)((Object)Iterable.class), type -> {
            if (type instanceof ParameterizedType) {
                return new Spf4jJMXBeanMapping.ListMXBeanType((ParameterizedType)type, this);
            }
            return Spf4jJMXBeanMapping.defaultHandler(type, this);
        });
        this.cache.safePut((Type)((Object)Map.class), type -> {
            if (type instanceof ParameterizedType) {
                return new Spf4jJMXBeanMapping.MapMXBeanType((ParameterizedType)type, this);
            }
            throw new IllegalArgumentException("Only parameterized maps can be converted to opentype, not " + type);
        });
        this.cache.safePut((Type)((Object)Map.Entry.class), type -> {
            if (type instanceof ParameterizedType) {
                return new MapEntryOpenTypeMapping((ParameterizedType)type, this);
            }
            return Spf4jJMXBeanMapping.defaultHandler(type, this);
        });
        this.cache.safePut((Type)((Object)Object.class), type -> {
            if (type instanceof GenericArrayType) {
                return new Spf4jJMXBeanMapping.GenericArrayMXBeanType((GenericArrayType)type, (JMXBeanMappingSupplier)this);
            }
            if (type instanceof Class && ((Class)type).isArray()) {
                return new Spf4jJMXBeanMapping.ArrayMXBeanType((Class)type, this);
            }
            return Spf4jJMXBeanMapping.defaultHandler(type, this);
        });
        this.cache.safePut((Type)((Object)File.class), type -> new Spf4jJMXBeanMapping.BasicMXBeanType(File.class, SimpleType.STRING){

            @Override
            public Object fromOpenValue(Object data) {
                return new File((String)data);
            }

            @Override
            public Object toOpenValue(Object data) {
                return data.toString();
            }
        });
        this.cache.safePut((Type)((Object)Path.class), type -> new Spf4jJMXBeanMapping.BasicMXBeanType(Path.class, SimpleType.STRING){

            @Override
            public Object fromOpenValue(Object data) {
                return Paths.get((String)data, new String[0]);
            }

            @Override
            public Object toOpenValue(Object data) {
                return data.toString();
            }
        });
    }

    @Override
    @Nullable
    public JMXBeanMapping get(Type t) throws NotSerializableException {
        Set<Type> ip = IN_PROGRESS.get();
        if (ip.contains(t)) {
            LOG.log(Level.FINE, "No openType mapping for {0} recursive data structure", t);
            return null;
        }
        try {
            ip.add(t);
            JMXBeanMapping val = this.cache.get(t);
            if (val == JMXBeanMapping.NOMAPPING) {
                JMXBeanMapping jMXBeanMapping = null;
                return jMXBeanMapping;
            }
            JMXBeanMapping jMXBeanMapping = val;
            return jMXBeanMapping;
        }
        catch (NotSerializableException ex) {
            TypeToken tt = TypeToken.of((Type)t);
            if (tt.isSubtypeOf(Serializable.class) || tt.getRawType().isInterface()) {
                LOG.log(Level.FINE, "No mapping for type {0}", t);
                LOG.log(Level.FINEST, "Exception Detail", ex);
                JMXBeanMapping jMXBeanMapping = null;
                return jMXBeanMapping;
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            TypeToken tt = TypeToken.of((Type)t);
            if (tt.isSubtypeOf(Serializable.class) || tt.getRawType().isInterface()) {
                LOG.log(Level.FINE, "No mapping for type {0}", t);
                LOG.log(Level.FINEST, "Exception Detail", ex);
                JMXBeanMapping jMXBeanMapping = null;
                return jMXBeanMapping;
            }
            NotSerializableException nsex = new NotSerializableException("Type " + t + "  must be serializable");
            nsex.addSuppressed(ex);
            throw nsex;
        }
        finally {
            ip.remove(t);
        }
    }

    public CachingTypeMapSupplierWrapper<JMXBeanMapping, NotSerializableException> getCache() {
        return this.cache;
    }

    public String toString() {
        return "Spf4jOpenTypeMapper{convertedTypes=" + this.cache + '}';
    }
}

