/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Marker;
import org.spf4j.base.avro.Converters;
import org.spf4j.base.avro.LogRecord;
import org.spf4j.log.Level;
import org.spf4j.log.Slf4jLogRecord;

public final class AvroLogRecordImpl
implements Slf4jLogRecord {
    private final LogRecord record;
    private boolean isLogged;

    public AvroLogRecordImpl(LogRecord record) {
        this(record, false);
    }

    public AvroLogRecordImpl(LogRecord record, boolean isLogged) {
        this.record = record;
        this.isLogged = isLogged;
    }

    @Override
    public LogRecord toLogRecord(String origin, String traceId) {
        return this.record;
    }

    @Override
    public Object[] getArguments() {
        return new Object[]{this.record};
    }

    @Override
    public Object[] getExtraArgumentsRaw() {
        return this.getArguments();
    }

    @Override
    public Object[] getExtraArguments() {
        return this.getArguments();
    }

    @Override
    public Throwable getExtraThrowable() {
        return Converters.convert(this.record.getOrigin(), this.record.getThrowable());
    }

    @Override
    public Level getLevel() {
        return Level.fromAvroLevel(this.record.getLevel());
    }

    @Override
    public String getLoggerName() {
        return this.record.getLogger();
    }

    @Override
    @Nullable
    public Marker getMarker() {
        return null;
    }

    @Override
    public String getMessage() {
        return "RemoteLog";
    }

    @Override
    public String getMessageFormat() {
        return this.getMessage();
    }

    @Override
    public int getNrMessageArguments() {
        return 0;
    }

    @Override
    public String getThreadName() {
        return this.record.getThr();
    }

    @Override
    public long getTimeStamp() {
        return this.record.getTs().toEpochMilli();
    }

    @Override
    public Instant getTimeStampInstant() {
        return this.record.getTs();
    }

    @Override
    public synchronized boolean isLogged() {
        return this.isLogged;
    }

    @Override
    public synchronized void setIsLogged() {
        this.isLogged = true;
    }

    @Override
    public void attach(Object obj) {
    }

    @Override
    public Set<Object> getAttachments() {
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAttachment(Object obj) {
        return false;
    }

    public String toString() {
        return "AvroLogRecordImpl{record=" + this.record + ", isLogged=" + this.isLogged + '}';
    }
}

