/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.spf4j.base.Arrays;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.Wrapper;
import org.spf4j.base.avro.LogRecord;
import org.spf4j.log.AvroLogRecordImpl;
import org.spf4j.log.Level;
import org.spf4j.log.LogAttribute;
import org.spf4j.log.SLf4jXLogAdapter;
import org.spf4j.log.Slf4jLogRecordImpl;
import org.spf4j.log.XLog;

@SuppressFBWarnings(value={"LO_SUSPECT_LOG_PARAMETER"})
public final class ExecContextLogger
implements Logger,
Wrapper<Logger> {
    private final XLog logger;

    public static ExecContextLogger from(Logger wrapped) {
        if (wrapped instanceof ExecContextLogger) {
            return (ExecContextLogger)wrapped;
        }
        return new ExecContextLogger(wrapped);
    }

    public ExecContextLogger(Logger wrapped) {
        this(new SLf4jXLogAdapter(wrapped));
    }

    public ExecContextLogger(XLog traceLogger) {
        this.logger = traceLogger;
    }

    @Override
    public Logger getWrapped() {
        return (Logger)this.logger.getWrapped();
    }

    public String getName() {
        return ((Logger)this.logger.getWrapped()).getName();
    }

    public boolean isEnabled(Level level, @Nullable Marker marker) {
        ExecutionContext ctx = ExecutionContexts.current();
        if (ctx == null) {
            return this.logger.isEnabled(level, marker);
        }
        String name = this.getName();
        Level backendOverwrite = ctx.getBackendMinLogLevel(name);
        if (backendOverwrite == null) {
            return this.logger.isEnabled(level, marker) || level.ordinal() >= ctx.getContextMinLogLevel(name).ordinal();
        }
        return this.logger.isEnabled(level, marker) || level.ordinal() >= Math.min(ctx.getContextMinLogLevel(name).ordinal(), backendOverwrite.ordinal());
    }

    public void log(ExecutionContext ctx, Level level, LogRecord log) {
        if (ctx == null) {
            this.logger.log(null, level, "RemoteLog", log);
            return;
        }
        String name = this.getName();
        boolean logged = false;
        if (this.logger.isEnabled(level, null)) {
            this.logger.log(null, level, "RemoteLog", LogAttribute.traceId(ctx.getId()), log);
            logged = true;
        } else {
            Level backendOverwrite = ctx.getBackendMinLogLevel(name);
            if (backendOverwrite != null && backendOverwrite.ordinal() <= level.ordinal()) {
                this.logger.logUpgrade(null, level, "RemoteLog", LogAttribute.traceId(ctx.getId()), log);
                logged = true;
            }
        }
        if (ctx.getContextMinLogLevel(name).ordinal() <= level.ordinal()) {
            ctx.addLog(new AvroLogRecordImpl(log, logged));
        }
    }

    public void log(@Nullable Marker marker, Level level, String msg, Object ... args) {
        this.log(ExecutionContexts.current(), marker, level, msg, args);
    }

    public void log(ExecutionContext ctx, @Nullable Marker marker, Level level, String msg, Object ... args) {
        boolean logged;
        if (ctx == null) {
            this.logger.log(marker, level, msg, args);
            return;
        }
        String name = this.getName();
        if (this.logger.isEnabled(level, marker)) {
            this.logger.log(null, level, msg, Arrays.append(args, LogAttribute.traceId(ctx.getId())));
            logged = true;
        } else {
            Level backendOverwrite = ctx.getBackendMinLogLevel(name);
            if (backendOverwrite == null) {
                logged = false;
            } else if (backendOverwrite.ordinal() <= level.ordinal()) {
                this.logger.logUpgrade(null, level, msg, Arrays.append(args, LogAttribute.traceId(ctx.getId())));
                logged = true;
            } else {
                logged = false;
            }
        }
        if (ctx.getContextMinLogLevel(name).ordinal() <= level.ordinal()) {
            ctx.addLog(new Slf4jLogRecordImpl(logged, name, level, marker, msg, args));
        }
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE, null);
    }

    public void trace(String msg) {
        this.log(null, Level.TRACE, msg, new Object[0]);
    }

    public void trace(String format, Object arg) {
        this.log(null, Level.TRACE, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.log(null, Level.TRACE, format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.log(null, Level.TRACE, format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.log(null, Level.TRACE, msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isEnabled(Level.TRACE, marker);
    }

    public void trace(Marker marker, String msg) {
        this.log(marker, Level.TRACE, msg, new Object[0]);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.log(marker, Level.TRACE, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.log(marker, Level.TRACE, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.log(marker, Level.TRACE, format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.log(marker, Level.TRACE, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG, null);
    }

    public void debug(String msg) {
        this.log(null, Level.DEBUG, msg, new Object[0]);
    }

    public void debug(String format, Object arg) {
        this.log(null, Level.DEBUG, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.log(null, Level.DEBUG, format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.log(null, Level.DEBUG, format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.log(null, Level.DEBUG, msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isEnabled(Level.DEBUG, marker);
    }

    public void debug(Marker marker, String msg) {
        this.log(marker, Level.DEBUG, msg, new Object[0]);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.log(marker, Level.DEBUG, format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.log(marker, Level.DEBUG, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.log(marker, Level.DEBUG, format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.log(marker, Level.DEBUG, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO, null);
    }

    public void info(String msg) {
        this.log(null, Level.INFO, msg, new Object[0]);
    }

    public void info(String format, Object arg) {
        this.log(null, Level.INFO, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log(null, Level.INFO, format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.log(null, Level.INFO, format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.log(null, Level.INFO, msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isEnabled(Level.INFO, marker);
    }

    public void info(Marker marker, String msg) {
        this.log(marker, Level.INFO, msg, new Object[0]);
    }

    public void info(Marker marker, String format, Object arg) {
        this.log(marker, Level.INFO, format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.log(marker, Level.INFO, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.log(marker, Level.INFO, format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.log(marker, Level.INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN, null);
    }

    public void warn(String msg) {
        this.log(null, Level.WARN, msg, new Object[0]);
    }

    public void warn(String format, Object arg) {
        this.log(null, Level.WARN, format, arg);
    }

    public void warn(String format, Object ... arguments) {
        this.log(null, Level.WARN, format, arguments);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log(null, Level.WARN, format, arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        this.log(null, Level.WARN, msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isEnabled(Level.WARN, marker);
    }

    public void warn(Marker marker, String msg) {
        this.log(marker, Level.WARN, msg, new Object[0]);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.log(marker, Level.WARN, format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.log(marker, Level.WARN, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.log(marker, Level.WARN, format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.log(marker, Level.WARN, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR, null);
    }

    public void error(String msg) {
        this.log(null, Level.ERROR, msg, new Object[0]);
    }

    public void error(String format, Object arg) {
        this.log(null, Level.ERROR, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log(null, Level.ERROR, format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.log(null, Level.ERROR, format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.log(null, Level.ERROR, msg, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isEnabled(Level.ERROR, marker);
    }

    public void error(Marker marker, String msg) {
        this.log(marker, Level.ERROR, msg, new Object[0]);
    }

    public void error(Marker marker, String format, Object arg) {
        this.log(marker, Level.ERROR, format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.log(marker, Level.ERROR, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.log(marker, Level.ERROR, format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.log(marker, Level.ERROR, msg, t);
    }

    public String toString() {
        return "ExecContextLogger{traceLogger=" + this.logger + '}';
    }
}

