/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import org.spf4j.base.avro.LogLevel;

public enum Level {
    TRACE(java.util.logging.Level.FINEST, LogLevel.TRACE),
    DEBUG(java.util.logging.Level.FINE, LogLevel.DEBUG),
    INFO(java.util.logging.Level.INFO, LogLevel.INFO),
    WARN(java.util.logging.Level.WARNING, LogLevel.WARN),
    ERROR(java.util.logging.Level.SEVERE, LogLevel.ERROR),
    OFF(java.util.logging.Level.OFF, LogLevel.UNKNOWN);

    private final java.util.logging.Level julLevel;
    private final LogLevel avroLevel;

    private Level(java.util.logging.Level julLevel, LogLevel avroLevel) {
        this.julLevel = julLevel;
        this.avroLevel = avroLevel;
    }

    public int getIntValue() {
        return this.julLevel.intValue();
    }

    public java.util.logging.Level getJulLevel() {
        return this.julLevel;
    }

    public LogLevel getAvroLevel() {
        return this.avroLevel;
    }

    public static Level fromAvroLevel(LogLevel level) {
        switch (level) {
            case UNKNOWN: 
            case DEBUG: {
                return DEBUG;
            }
            case ERROR: {
                return ERROR;
            }
            case INFO: {
                return INFO;
            }
            case TRACE: {
                return TRACE;
            }
            case WARN: {
                return WARN;
            }
        }
        throw new IllegalArgumentException("Unsupported LogLevel " + level);
    }

    public static Level fromJulLevel(int severity) {
        if (severity <= TRACE.getIntValue()) {
            return TRACE;
        }
        if (severity <= DEBUG.getIntValue()) {
            return DEBUG;
        }
        if (severity <= INFO.getIntValue()) {
            return INFO;
        }
        if (severity <= WARN.getIntValue()) {
            return WARN;
        }
        if (severity <= ERROR.getIntValue()) {
            return ERROR;
        }
        return OFF;
    }
}

