/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.spf4j.base.CharSequences;
import org.spf4j.base.Json;
import org.spf4j.base.JsonWriteable;
import org.spf4j.base.Pair;
import org.spf4j.base.StackSamples;
import org.spf4j.io.AppendableWriter;
import org.spf4j.log.Level;
import org.spf4j.log.Slf4jLogRecord;

@SuppressFBWarnings(value={"PIS_POSSIBLE_INCOMPLETE_SERIALIZATION", "SE_NO_SUITABLE_CONSTRUCTOR"})
public final class LogAttribute<T>
extends Pair<String, T>
implements JsonWriteable,
Marker {
    private static final long serialVersionUID = 1L;
    public static final String ID_ATTR_NAME = "trId";
    public static final String PROFILE_SAMPLES_ATTR_NAME = "prSamples";

    public LogAttribute(String first, T second) {
        super(first, second);
    }

    public String getName() {
        return (String)this.first;
    }

    public static <T> LogAttribute<T> of(String val, T obj) {
        return new LogAttribute<T>(val, obj);
    }

    public static LogAttribute<CharSequence> traceId(CharSequence id) {
        return new LogAttribute<CharSequence>(ID_ATTR_NAME, id);
    }

    public static LogAttribute<StackSamples> profileSamples(StackSamples ss) {
        return new LogAttribute<StackSamples>(PROFILE_SAMPLES_ATTR_NAME, ss);
    }

    public static LogAttribute<Level> origLevel(Level level) {
        return new LogAttribute<Level>("origLevel", level);
    }

    public static LogAttribute<Level> origLoggerName(String loggerName) {
        return new LogAttribute<String>("origLogger", loggerName);
    }

    public static LogAttribute<Level> origTimeStamp(Instant instant) {
        return new LogAttribute<Instant>("origTs", instant);
    }

    public static LogAttribute<Level> origTimeStamp(long millisSinceEpoch) {
        return new LogAttribute<Instant>("origTs", Instant.ofEpochMilli(millisSinceEpoch));
    }

    public static LogAttribute<Slf4jLogRecord> log(Slf4jLogRecord record) {
        return new LogAttribute<Slf4jLogRecord>("log", record);
    }

    public static LogAttribute<Long> execTimeMicros(long time, TimeUnit tu) {
        return new LogAttribute<Long>("execUs", tu.toMicros(time));
    }

    public static LogAttribute<Long> value(String what, long value) {
        return new LogAttribute<Long>(what, value);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(32);
        this.writeJsonTo(result);
        return result.toString();
    }

    @Override
    public void writeJsonTo(Appendable appendable) throws IOException {
        JsonGenerator gen = Json.FACTORY.createGenerator((Writer)new AppendableWriter(appendable));
        gen.setCodec((ObjectCodec)Json.MAPPER);
        this.writeJsonTo(gen);
        gen.flush();
    }

    public void writeJsonTo(JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName((String)this.first);
        gen.writeObject(this.second);
        gen.writeEndObject();
    }

    public static LogAttribute<Object> fromJson(CharSequence jsonStr) {
        try {
            JsonParser parser = Json.FACTORY.createParser(CharSequences.reader(jsonStr));
            parser.setCodec((ObjectCodec)Json.MAPPER);
            Map val = (Map)parser.readValueAs(Map.class);
            return LogAttribute.fromMap(val);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static LogAttribute<Object> fromMap(Map<String, Object> val) {
        if (val.size() != 1) {
            throw new IllegalArgumentException("No Log Attribute: " + val);
        }
        Map.Entry<String, Object> entry = val.entrySet().iterator().next();
        Object value = entry.getValue();
        return LogAttribute.of(entry.getKey(), value);
    }

    public void add(Marker reference) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Marker reference) {
        return false;
    }

    public boolean hasChildren() {
        return false;
    }

    public boolean hasReferences() {
        return false;
    }

    public Iterator<Marker> iterator() {
        return Collections.emptyListIterator();
    }

    public boolean contains(Marker other) {
        return false;
    }

    public boolean contains(String name) {
        return false;
    }

    private Object writeReplace() throws ObjectStreamException {
        StringBuilder sb = new StringBuilder(32);
        this.writeJsonTo(sb);
        return new AttrProxy(sb);
    }

    private static final class AttrProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private StringBuilder json;

        AttrProxy(StringBuilder json) {
            this.json = json;
        }

        private Object readResolve() {
            return LogAttribute.fromJson(this.json);
        }
    }
}

