/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Marker;
import org.spf4j.base.CoreTextMediaType;
import org.spf4j.base.EscapeJsonStringAppendableWrapper;
import org.spf4j.base.Slf4jMessageFormatter;
import org.spf4j.base.Throwables;
import org.spf4j.base.avro.AThrowables;
import org.spf4j.base.avro.LogRecord;
import org.spf4j.base.avro.Throwable;
import org.spf4j.io.ByteArrayBuilder;
import org.spf4j.io.ConfigurableAppenderSupplier;
import org.spf4j.io.ObjectAppender;
import org.spf4j.log.Level;
import org.spf4j.log.Slf4jLogRecord;
import org.spf4j.recyclable.impl.ArraySuppliers;
import org.spf4j.recyclable.impl.ThreadLocalRecyclingSupplier;

@ParametersAreNonnullByDefault
@ThreadSafe
public final class LogPrinter {
    private static final ConcurrentMap<Charset, ThreadLocalRecyclingSupplier<Buffer>> BUFFERS = new ConcurrentHashMap<Charset, ThreadLocalRecyclingSupplier<Buffer>>();
    private final ThreadLocalRecyclingSupplier<Buffer> tlBuffer;
    private final ConfigurableAppenderSupplier toStringer;
    private final DateTimeFormatter fmt;

    public ConfigurableAppenderSupplier getAppenderSupplier() {
        return this.toStringer;
    }

    public LogPrinter() {
        this(DateTimeFormatter.ISO_INSTANT, Charset.defaultCharset());
    }

    public LogPrinter(Charset charset) {
        this(DateTimeFormatter.ISO_INSTANT, charset);
    }

    public LogPrinter(DateTimeFormatter fmt, Charset charset) {
        this.fmt = fmt;
        this.toStringer = new ConfigurableAppenderSupplier();
        this.tlBuffer = BUFFERS.computeIfAbsent(charset, cs -> new ThreadLocalRecyclingSupplier<Buffer>(() -> new Buffer((Charset)cs)));
    }

    public OutputStream print(Slf4jLogRecord record, OutputStream os, OutputStream errStream) {
        if (record.getLevel() == Level.ERROR) {
            this.print(record, errStream);
            return errStream;
        }
        this.print(record, os);
        return os;
    }

    public void print(Slf4jLogRecord record, OutputStream os) {
        Buffer buff = this.tlBuffer.get();
        boolean recycle = true;
        try {
            buff.clear();
            this.print(record, (BufferedAppendable)buff, "");
            buff.flush();
            int len = buff.size();
            os.write(buff.getBytes(), 0, len);
            if (len > Buffer.MAX_BUFFER_SIZE) {
                recycle = false;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            if (recycle) {
                this.tlBuffer.recycle(buff);
            }
        }
    }

    public byte[] printToBytes(Slf4jLogRecord record) {
        Buffer buff = this.tlBuffer.get();
        boolean recycle = true;
        try {
            buff.clear();
            this.print(record, (BufferedAppendable)buff, "");
            buff.flush();
            int size = buff.size();
            if (size > Buffer.MAX_BUFFER_SIZE) {
                recycle = false;
            }
            byte[] byArray = Arrays.copyOf(buff.getBytes(), size);
            return byArray;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            if (recycle) {
                this.tlBuffer.recycle(buff);
            }
        }
    }

    public void print(LogRecord record, OutputStream os) throws IOException {
        this.printTo(os, record, "");
        os.flush();
    }

    public void printTo(StringBuilder sb, Slf4jLogRecord record, String annotate) {
        try {
            this.print(record, BufferedAppendable.from(sb), annotate);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void printTo(OutputStream stream, LogRecord record, String annotate) {
        Buffer buff = this.tlBuffer.get();
        buff.clear();
        try {
            this.print(record, (BufferedAppendable)buff, annotate);
            buff.flush();
            stream.write(buff.getBytes(), 0, buff.size());
            stream.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void printTo(PrintStream stream, Slf4jLogRecord record, String annotate) {
        Buffer buff = this.tlBuffer.get();
        buff.clear();
        try {
            this.print(record, (BufferedAppendable)buff, annotate);
            buff.flush();
            stream.write(buff.getBytes(), 0, buff.size());
            stream.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    static void printMarker(Marker marker, Appendable wr, Appendable wrapper) throws IOException {
        if (marker.hasReferences()) {
            wr.append('{');
            wr.append('\"');
            wrapper.append(marker.getName());
            wr.append("\":[");
            Iterator it = marker.iterator();
            if (it.hasNext()) {
                LogPrinter.printMarker((Marker)it.next(), wr, wrapper);
                while (it.hasNext()) {
                    wr.append(',');
                    LogPrinter.printMarker((Marker)it.next(), wr, wrapper);
                }
            }
            wr.append("]}");
        } else {
            wr.append('\"');
            wrapper.append(marker.getName());
            wr.append('\"');
        }
    }

    private void print(Slf4jLogRecord record, BufferedAppendable app, String annotate) throws IOException {
        int i;
        Appendable wr = app.getAppendable();
        Appendable wrapper = app.getJsonStringEscapingAppendable();
        wr.append(annotate);
        this.fmt.formatTo(Instant.ofEpochMilli(record.getTimeStamp()), wr);
        wr.append(' ');
        String level = record.getLevel().toString();
        wr.append(level);
        wr.append(' ');
        Marker marker = record.getMarker();
        if (marker != null) {
            LogPrinter.printMarker(marker, wr, wrapper);
            wr.append(' ');
        }
        Throwables.writeAbreviatedClassName(record.getLoggerName(), wr);
        wr.append(" \"");
        wrapper.append(record.getThreadName());
        wr.append("\" \"");
        Object[] arguments = record.getArguments();
        wr.append("\" ");
        java.lang.Throwable t = null;
        if (i < arguments.length) {
            boolean first = true;
            for (i = Slf4jMessageFormatter.format(LogPrinter::exHandle, 0, wrapper, record.getMessageFormat(), this.toStringer, arguments); i < arguments.length; ++i) {
                Object arg = arguments[i];
                if (arg instanceof java.lang.Throwable) {
                    if (t == null) {
                        t = (java.lang.Throwable)arg;
                        continue;
                    }
                    t.addSuppressed((java.lang.Throwable)arg);
                    continue;
                }
                if (!first) {
                    wr.append(", ");
                } else {
                    wr.append('[');
                    first = false;
                }
                this.printJsonObject(arg, app);
            }
            if (!first) {
                wr.append(']');
            }
        }
        if (t != null) {
            wr.append('\n');
            Throwables.writeTo(t, wr, Throwables.PackageDetail.SHORT);
        } else {
            wr.append('\n');
        }
    }

    private void print(LogRecord record, BufferedAppendable ba, String annotate) throws IOException {
        Throwable t;
        Appendable wr = ba.getAppendable();
        Appendable wrapper = ba.getJsonStringEscapingAppendable();
        wr.append(annotate);
        wr.append('\"');
        wrapper.append(record.getOrigin());
        wr.append("\" ");
        this.fmt.formatTo(record.getTs(), wr);
        wr.append(' ');
        String level = record.getLevel().toString();
        wr.append(level);
        wr.append(' ');
        wr.append(record.getLogger());
        wr.append(" \"");
        wrapper.append(record.getThr());
        wrapper.append(':');
        wrapper.append(record.getTrId());
        wr.append("\" \"");
        wrapper.append(record.getMsg());
        wr.append("\" ");
        Map attrs = record.getAttrs();
        List xtra = record.getXtra();
        if (attrs.size() + xtra.size() > 0) {
            boolean first = true;
            wr.append('[');
            for (Map.Entry entry : attrs.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    wr.append(',');
                }
                this.printJsonObject(entry, ba);
            }
            for (Map.Entry obj : xtra) {
                if (first) {
                    first = false;
                } else {
                    wr.append(',');
                }
                this.printJsonObject(obj, ba);
            }
            wr.append(']');
        }
        if ((t = record.getThrowable()) != null) {
            wr.append('\n');
            AThrowables.writeTo(t, wr, Throwables.PackageDetail.SHORT, true, "");
        } else {
            wr.append('\n');
        }
    }

    private void printJsonObject(@Nullable Object obj, BufferedAppendable app) throws IOException {
        if (obj == null) {
            app.getAppendable().append("null");
        } else {
            ObjectAppender ostrApp = this.toStringer.get(CoreTextMediaType.APPLICATION_JSON, obj.getClass());
            if (ostrApp != null) {
                int currentPos = app.getCurrentPos();
                try {
                    ostrApp.append(obj, app.getAppendable(), this.toStringer);
                    return;
                }
                catch (IOException | RuntimeException e) {
                    app.resetPos(currentPos);
                }
            }
            Appendable wr = app.getAppendable();
            Appendable wrapper = app.getJsonStringEscapingAppendable();
            ostrApp = this.toStringer.get(CoreTextMediaType.TEXT_PLAIN, obj.getClass());
            wr.append('\"');
            int currentPos = app.getCurrentPos();
            try {
                ostrApp.append(obj, wrapper, this.toStringer);
            }
            catch (IOException | RuntimeException e) {
                app.resetPos(currentPos);
                LogPrinter.exHandle(obj, wrapper, e);
            }
            wr.append('\"');
        }
    }

    static void exHandle(Object obj, Appendable sbuf, java.lang.Throwable t) throws IOException {
        String className = obj.getClass().getName();
        sbuf.append("[FAILED toString() for ");
        sbuf.append(className);
        sbuf.append("]{");
        Throwables.writeTo(t, sbuf, Throwables.PackageDetail.SHORT);
        sbuf.append('}');
    }

    public String toString() {
        return "LogPrinter{toStringer=" + this.toStringer + ", fmt=" + this.fmt + '}';
    }

    private static final class Buffer
    implements BufferedAppendable {
        private static final int MAX_BUFFER_SIZE = Integer.getInteger("spf4j.logPrinter", 32768);
        private final ByteArrayBuilder bab = new ByteArrayBuilder(512, ArraySuppliers.Bytes.JAVA_NEW);
        private final Writer writer;
        private final EscapeJsonStringAppendableWrapper writerEscaper;

        Buffer(Charset charset) {
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.bab, charset));
            this.writerEscaper = new EscapeJsonStringAppendableWrapper(this.writer);
        }

        private void clear() {
            try {
                this.writer.flush();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.bab.reset();
        }

        @Override
        public Appendable getAppendable() {
            return this.writer;
        }

        @Override
        public Appendable getJsonStringEscapingAppendable() {
            return this.writerEscaper;
        }

        private void flush() {
            try {
                this.writer.flush();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        private byte[] getBytes() {
            return this.bab.getBuffer();
        }

        private int size() {
            return this.bab.size();
        }

        @Override
        public int getCurrentPos() {
            this.flush();
            return this.bab.size();
        }

        @Override
        @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
        public void resetPos(int pos) {
            this.flush();
            this.bab.resetCountTo(pos);
        }
    }

    static interface BufferedAppendable {
        public Appendable getAppendable();

        public Appendable getJsonStringEscapingAppendable();

        public int getCurrentPos();

        public void resetPos(int var1);

        public static BufferedAppendable from(final StringBuilder sb) {
            return new BufferedAppendable(){
                private Appendable escaper = null;

                @Override
                public Appendable getAppendable() {
                    return sb;
                }

                @Override
                public Appendable getJsonStringEscapingAppendable() {
                    if (this.escaper == null) {
                        this.escaper = new EscapeJsonStringAppendableWrapper(sb);
                    }
                    return this.escaper;
                }

                @Override
                public int getCurrentPos() {
                    return sb.length();
                }

                @Override
                public void resetPos(int pos) {
                    sb.setLength(pos);
                }
            };
        }
    }
}

