/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.spf4j.base.Arrays;
import org.spf4j.log.Level;
import org.spf4j.log.LogAttribute;

public final class LogUtils {
    private LogUtils() {
    }

    @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON", "SF_SWITCH_FALLTHROUGH"})
    public static void logUpgrade(Logger log, @Nullable Marker marker, Level level, String format, Object ... pargs) {
        Object[] args = pargs;
        switch (level) {
            case TRACE: {
                if (log.isTraceEnabled()) {
                    if (marker == null) {
                        log.trace(format, args);
                        break;
                    }
                    log.trace(marker, format, args);
                    break;
                }
                if (args == pargs) {
                    args = Arrays.append(args, LogAttribute.origLevel(level));
                }
            }
            case DEBUG: {
                if (log.isDebugEnabled()) {
                    if (marker == null) {
                        log.debug(format, args);
                        break;
                    }
                    log.debug(marker, format, args);
                    break;
                }
                if (args == pargs) {
                    args = Arrays.append(args, LogAttribute.origLevel(level));
                }
            }
            case INFO: {
                if (log.isInfoEnabled()) {
                    if (marker == null) {
                        log.info(format, args);
                        break;
                    }
                    log.info(marker, format, args);
                    break;
                }
                if (args == pargs) {
                    args = Arrays.append(args, LogAttribute.origLevel(level));
                }
            }
            case WARN: {
                if (log.isWarnEnabled()) {
                    if (marker == null) {
                        log.warn(format, args);
                        break;
                    }
                    log.warn(marker, format, args);
                    break;
                }
                if (args == pargs) {
                    args = Arrays.append(args, LogAttribute.origLevel(level));
                }
            }
            case ERROR: {
                if (log.isErrorEnabled()) {
                    if (marker == null) {
                        log.error(format, args);
                        break;
                    }
                    log.error(marker, format, args);
                    break;
                }
                throw new IllegalStateException("Error not enabled for  " + log.getName());
            }
            default: {
                throw new IllegalStateException("Invalid level " + (Object)((Object)level));
            }
        }
    }

    @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON", "SF_SWITCH_FALLTHROUGH"})
    public static void logUpgrade(java.util.logging.Logger log, Level plevel, String format, Object ... pargs) {
        Level[] values = Level.values();
        Level level = plevel;
        while (true) {
            java.util.logging.Level julLevel;
            if (log.isLoggable(julLevel = level.getJulLevel())) {
                log.log(julLevel, format, pargs);
                return;
            }
            if (level == Level.ERROR) {
                throw new IllegalStateException();
            }
            level = values[level.ordinal() + 1];
        }
    }
}

