/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;
import org.spf4j.base.Pair;
import org.spf4j.base.avro.Method;
import org.spf4j.text.MessageFormat;

public final class SLF4JBridgeHandler
extends Handler {
    private static final String FQCN = java.util.logging.Logger.class.getName();
    private static final String UNKNOWN_LOGGER_NAME = "unknown.jul.logger";
    private static final int TRACE_LEVEL_THRESHOLD = Level.FINEST.intValue();
    private static final int DEBUG_LEVEL_THRESHOLD = Level.FINE.intValue();
    private static final int INFO_LEVEL_THRESHOLD = Level.INFO.intValue();
    private static final int WARN_LEVEL_THRESHOLD = Level.WARNING.intValue();
    private static final ThreadLocal<Reference<StringBuilder>> SB = new ThreadLocal<Reference<StringBuilder>>(){

        @Override
        protected Reference<StringBuilder> initialValue() {
            return new SoftReference<StringBuilder>(new StringBuilder(64));
        }
    };
    private static final LoadingCache<String, MessageFormat> FORMAT_CACHE = CacheBuilder.newBuilder().maximumSize((long)Integer.getInteger("spf4j.julBridge.MaxFormatCacheSize", 1024).intValue()).build((CacheLoader)new CacheLoader<String, MessageFormat>(){

        public MessageFormat load(String key) {
            return new MessageFormat(key);
        }
    });
    private static final boolean ALWAYS_TRY_INFER = Boolean.getBoolean("spf4j.jul2slf4jBridge.alwaysTryInferSource");
    @Nullable
    private static final Field NEED_INFER = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            try {
                Field declaredField = LogRecord.class.getDeclaredField("needToInferCaller");
                declaredField.setAccessible(true);
                return declaredField;
            }
            catch (NoSuchFieldException | SecurityException ex) {
                LoggerFactory.getLogger(SLF4JBridgeHandler.class).debug("jul to slf4j bridge will not differentiate between computed caller info and provided", (Throwable)ex);
                return null;
            }
        }
    });

    public static void install() {
        SLF4JBridgeHandler.getRootLogger().addHandler(new SLF4JBridgeHandler());
    }

    private static java.util.logging.Logger getRootLogger() {
        return LogManager.getLogManager().getLogger("");
    }

    public static void uninstall() {
        java.util.logging.Logger rootLogger = SLF4JBridgeHandler.getRootLogger();
        Handler[] handlers = rootLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (!(handlers[i] instanceof SLF4JBridgeHandler)) continue;
            rootLogger.removeHandler(handlers[i]);
        }
    }

    public static boolean isInstalled() {
        java.util.logging.Logger rootLogger = SLF4JBridgeHandler.getRootLogger();
        Handler[] handlers = rootLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (!(handlers[i] instanceof SLF4JBridgeHandler)) continue;
            return true;
        }
        return false;
    }

    public static void removeHandlersForRootLogger() {
        java.util.logging.Logger rootLogger = SLF4JBridgeHandler.getRootLogger();
        Handler[] handlers = rootLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            rootLogger.removeHandler(handlers[i]);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    private static Logger getSLF4JLogger(LogRecord record) {
        String name = record.getLoggerName();
        if (name == null) {
            name = UNKNOWN_LOGGER_NAME;
        }
        return LoggerFactory.getLogger((String)name);
    }

    private static void callLocationAwareLogger(LocationAwareLogger lal, LogRecord record) {
        int julLevelValue = record.getLevel().intValue();
        int slf4jLevel = julLevelValue <= TRACE_LEVEL_THRESHOLD ? 0 : (julLevelValue <= DEBUG_LEVEL_THRESHOLD ? 10 : (julLevelValue <= INFO_LEVEL_THRESHOLD ? 20 : (julLevelValue <= WARN_LEVEL_THRESHOLD ? 30 : 40)));
        Pair<String, Object[]> messageArgs = SLF4JBridgeHandler.getMessageI18N(record);
        Method m = SLF4JBridgeHandler.getSourceMethodInfo(record);
        if (m != null) {
            lal.log(null, m.toString(), slf4jLevel, messageArgs.getFirst(), messageArgs.getSecond(), record.getThrown());
        } else {
            lal.log(null, FQCN, slf4jLevel, messageArgs.getFirst(), messageArgs.getSecond(), record.getThrown());
        }
    }

    @SuppressFBWarnings(value={"UCC_UNRELATED_COLLECTION_CONTENTS"})
    private static void callPlainSLF4JLogger(Logger slf4jLogger, LogRecord record) {
        Pair<String, Object[]> message = SLF4JBridgeHandler.getMessageI18N(record);
        Object[] args = message.getSecond();
        if (args == null || args.length == 0) {
            SLF4JBridgeHandler.logEfficient(message.getFirst(), record, slf4jLogger);
        } else {
            Object[] pargs;
            int julLevelValue = record.getLevel().intValue();
            Throwable thrown = record.getThrown();
            Method m = SLF4JBridgeHandler.getSourceMethodInfo(record);
            if (m == null) {
                if (thrown == null) {
                    pargs = args;
                } else {
                    pargs = Arrays.copyOf(args, args.length + 1);
                    pargs[args.length] = thrown;
                }
            } else if (thrown == null) {
                pargs = Arrays.copyOf(args, args.length + 1);
                pargs[args.length] = m;
            } else {
                pargs = Arrays.copyOf(args, args.length + 2);
                pargs[args.length] = m;
                pargs[args.length + 1] = thrown;
            }
            if (julLevelValue <= TRACE_LEVEL_THRESHOLD) {
                slf4jLogger.trace(message.getFirst(), pargs);
            } else if (julLevelValue <= DEBUG_LEVEL_THRESHOLD) {
                slf4jLogger.debug(message.getFirst(), pargs);
            } else if (julLevelValue <= INFO_LEVEL_THRESHOLD) {
                slf4jLogger.info(message.getFirst(), pargs);
            } else if (julLevelValue <= WARN_LEVEL_THRESHOLD) {
                slf4jLogger.warn(message.getFirst(), pargs);
            } else {
                slf4jLogger.error(message.getFirst(), pargs);
            }
        }
    }

    public static void logEfficient(String i18nMessage, LogRecord record, Logger slf4jLogger) {
        int julLevelValue = record.getLevel().intValue();
        Throwable thrown = record.getThrown();
        Method m = SLF4JBridgeHandler.getSourceMethodInfo(record);
        if (thrown != null) {
            if (julLevelValue <= TRACE_LEVEL_THRESHOLD) {
                if (m != null) {
                    slf4jLogger.trace(i18nMessage, (Object)m, (Object)thrown);
                } else {
                    slf4jLogger.trace(i18nMessage, thrown);
                }
            } else if (julLevelValue <= DEBUG_LEVEL_THRESHOLD) {
                if (m != null) {
                    slf4jLogger.debug(i18nMessage, (Object)m, (Object)thrown);
                } else {
                    slf4jLogger.debug(i18nMessage, thrown);
                }
            } else if (julLevelValue <= INFO_LEVEL_THRESHOLD) {
                if (m != null) {
                    slf4jLogger.info(i18nMessage, (Object)m, (Object)thrown);
                } else {
                    slf4jLogger.info(i18nMessage, thrown);
                }
            } else if (julLevelValue <= WARN_LEVEL_THRESHOLD) {
                if (m != null) {
                    slf4jLogger.warn(i18nMessage, (Object)m, (Object)thrown);
                } else {
                    slf4jLogger.warn(i18nMessage, thrown);
                }
            } else if (m != null) {
                slf4jLogger.error(i18nMessage, (Object)m, (Object)thrown);
            } else {
                slf4jLogger.error(i18nMessage, thrown);
            }
        } else if (julLevelValue <= TRACE_LEVEL_THRESHOLD) {
            if (m != null) {
                slf4jLogger.trace(i18nMessage, (Object)m);
            } else {
                slf4jLogger.trace(i18nMessage);
            }
        } else if (julLevelValue <= DEBUG_LEVEL_THRESHOLD) {
            if (m != null) {
                slf4jLogger.debug(i18nMessage, (Object)m);
            } else {
                slf4jLogger.debug(i18nMessage);
            }
        } else if (julLevelValue <= INFO_LEVEL_THRESHOLD) {
            if (m != null) {
                slf4jLogger.info(i18nMessage, (Object)m);
            } else {
                slf4jLogger.info(i18nMessage);
            }
        } else if (julLevelValue <= WARN_LEVEL_THRESHOLD) {
            if (m != null) {
                slf4jLogger.warn(i18nMessage, (Object)m);
            } else {
                slf4jLogger.warn(i18nMessage);
            }
        } else if (m != null) {
            slf4jLogger.error(i18nMessage, (Object)m);
        } else {
            slf4jLogger.error(i18nMessage);
        }
    }

    @Nullable
    public static Method getSourceMethodInfo(LogRecord record) {
        Method m;
        try {
            m = ALWAYS_TRY_INFER || NEED_INFER != null && !NEED_INFER.getBoolean(record) ? new Method(record.getSourceClassName(), record.getSourceMethodName()) : null;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        return m;
    }

    @Nonnull
    private static Pair<String, Object[]> getMessageI18N(LogRecord record) {
        String message = record.getMessage();
        if (message == null) {
            return Pair.of("", record.getParameters());
        }
        ResourceBundle bundle = record.getResourceBundle();
        if (bundle != null) {
            try {
                message = bundle.getString(message);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        Object[] params = record.getParameters();
        StringBuilder msg = SB.get().get();
        if (msg == null) {
            msg = new StringBuilder(64);
            SB.set(new SoftReference<StringBuilder>(msg));
        } else {
            msg.setLength(0);
        }
        if (params != null && params.length > 0) {
            try {
                boolean[] used;
                try {
                    used = ((MessageFormat)FORMAT_CACHE.getUnchecked((Object)message)).format(params, msg);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                int nrLeft = 0;
                for (boolean u : used) {
                    if (u) continue;
                    ++nrLeft;
                }
                if (nrLeft == 0) {
                    return Pair.of(msg.toString(), org.spf4j.base.Arrays.EMPTY_OBJ_ARRAY);
                }
                Object[] left = new Object[nrLeft];
                int j = 0;
                for (int i = 0; i < used.length; ++i) {
                    if (used[i]) continue;
                    left[j++] = params[i];
                }
                return Pair.of(msg.toString(), left);
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(SLF4JBridgeHandler.class).warn("Unable to format {} with {}", new Object[]{message, params, e});
                return Pair.of(message, org.spf4j.base.Arrays.EMPTY_OBJ_ARRAY);
            }
        }
        return Pair.of(message, org.spf4j.base.Arrays.EMPTY_OBJ_ARRAY);
    }

    @Override
    public void publish(LogRecord record) {
        try {
            Logger slf4jLogger = SLF4JBridgeHandler.getSLF4JLogger(record);
            if (slf4jLogger instanceof LocationAwareLogger) {
                SLF4JBridgeHandler.callLocationAwareLogger((LocationAwareLogger)slf4jLogger, record);
            } else {
                SLF4JBridgeHandler.callPlainSLF4JLogger(slf4jLogger, record);
            }
        }
        catch (RuntimeException ex) {
            LoggerFactory.getLogger(SLF4JBridgeHandler.class).warn("Unable to publish {}", (Object)record, (Object)ex);
        }
    }
}

