/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.spf4j.log.Level;
import org.spf4j.log.LogUtils;
import org.spf4j.log.XLog;

public final class SLf4jXLogAdapter
implements XLog {
    private final Logger wrapped;

    @SuppressFBWarnings(value={"LO_SUSPECT_LOG_PARAMETER"})
    public SLf4jXLogAdapter(Logger wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON", "SF_SWITCH_FALLTHROUGH"})
    public void logUpgrade(@Nullable Marker marker, Level level, String format, Object ... pargs) {
        LogUtils.logUpgrade(this.wrapped, marker, level, format, pargs);
    }

    @Override
    public void log(@Nullable Marker marker, Level level, String format, Object ... args) {
        switch (level) {
            case TRACE: {
                if (marker != null) {
                    this.wrapped.trace(marker, format, args);
                    break;
                }
                this.wrapped.trace(format, args);
                break;
            }
            case DEBUG: {
                if (marker != null) {
                    this.wrapped.debug(marker, format, args);
                    break;
                }
                this.wrapped.debug(format, args);
                break;
            }
            case INFO: {
                if (marker != null) {
                    this.wrapped.info(marker, format, args);
                    break;
                }
                this.wrapped.info(format, args);
                break;
            }
            case WARN: {
                if (marker != null) {
                    this.wrapped.warn(marker, format, args);
                    break;
                }
                this.wrapped.warn(format, args);
                break;
            }
            case ERROR: {
                if (marker != null) {
                    this.wrapped.error(marker, format, args);
                    break;
                }
                this.wrapped.error(format, args);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported " + (Object)((Object)level));
            }
        }
    }

    @Override
    public boolean isEnabled(Level level, @Nullable Marker marker) {
        switch (level) {
            case TRACE: {
                if (marker == null) {
                    return this.wrapped.isTraceEnabled();
                }
                return this.wrapped.isTraceEnabled(marker);
            }
            case DEBUG: {
                if (marker == null) {
                    return this.wrapped.isDebugEnabled();
                }
                return this.wrapped.isDebugEnabled(marker);
            }
            case INFO: {
                if (marker == null) {
                    return this.wrapped.isInfoEnabled();
                }
                return this.wrapped.isInfoEnabled(marker);
            }
            case WARN: {
                if (marker == null) {
                    return this.wrapped.isWarnEnabled();
                }
                return this.wrapped.isWarnEnabled(marker);
            }
            case ERROR: {
                if (marker == null) {
                    return this.wrapped.isErrorEnabled();
                }
                return this.wrapped.isErrorEnabled(null);
            }
        }
        throw new UnsupportedOperationException("Unsupported " + (Object)((Object)level));
    }

    @Override
    public Logger getWrapped() {
        return this.wrapped;
    }

    public String toString() {
        return "SLf4jXLogAdapter{wrapped=" + this.wrapped + '}';
    }
}

