/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Marker;
import org.spf4j.base.StackSamples;
import org.spf4j.base.avro.Converters;
import org.spf4j.base.avro.LogRecord;
import org.spf4j.base.avro.StackSampleElement;
import org.spf4j.log.Level;
import org.spf4j.log.LogAttribute;

public interface Slf4jLogRecord {
    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Object[] getArguments();

    @Nonnull
    public Object[] getExtraArgumentsRaw();

    @Nonnull
    public Object[] getExtraArguments();

    @Nullable
    public Throwable getExtraThrowable();

    public Level getLevel();

    public String getLoggerName();

    @Nullable
    public Marker getMarker();

    @Nonnull
    public String getMessage();

    public String getMessageFormat();

    public int getNrMessageArguments();

    public String getThreadName();

    public long getTimeStamp();

    default public Instant getTimeStampInstant() {
        return Instant.ofEpochMilli(this.getTimeStamp());
    }

    public boolean isLogged();

    public void setIsLogged();

    public void attach(Object var1);

    public Set<Object> getAttachments();

    public boolean hasAttachment(Object var1);

    public static int compareByTimestamp(Slf4jLogRecord a, Slf4jLogRecord b) {
        long timeDiff = a.getTimeStamp() - b.getTimeStamp();
        if (timeDiff > 0L) {
            return 1;
        }
        if (timeDiff < 0L) {
            return -1;
        }
        return 0;
    }

    @SuppressFBWarnings(value={"WOC_WRITE_ONLY_COLLECTION_LOCAL"})
    default public LogRecord toLogRecord(String origin, String ptraceId) {
        ArrayList<Object> xArgs;
        Throwable extraThrowable = this.getExtraThrowable();
        Marker marker = this.getMarker();
        Object[] extraArguments = this.getExtraArguments();
        HashMap attribs = null;
        String traceId = ptraceId;
        List<StackSampleElement> profiles = Collections.EMPTY_LIST;
        if (extraArguments.length == 0) {
            xArgs = Collections.EMPTY_LIST;
        } else {
            LogAttribute la;
            int nrAttribs = 0;
            for (Object obj : extraArguments) {
                String name;
                if (!(obj instanceof LogAttribute)) continue;
                la = (LogAttribute)obj;
                switch (name = la.getName()) {
                    case "trId": {
                        traceId = la.getValue().toString();
                        break;
                    }
                    case "prSamples": {
                        profiles = Converters.convert((StackSamples)la.getValue());
                        break;
                    }
                }
                ++nrAttribs;
            }
            if (nrAttribs == 0) {
                xArgs = Arrays.asList(extraArguments);
            } else {
                xArgs = nrAttribs == extraArguments.length ? Collections.EMPTY_LIST : new ArrayList<Object>(extraArguments.length - nrAttribs);
                attribs = Maps.newHashMapWithExpectedSize((int)(nrAttribs + (marker == null ? 0 : 1)));
                for (Object obj : extraArguments) {
                    if (obj instanceof LogAttribute) {
                        String aName;
                        la = (LogAttribute)obj;
                        switch (aName = la.getName()) {
                            case "trId": 
                            case "prSamples": {
                                break;
                            }
                            default: {
                                attribs.put(aName, la.getValue());
                                break;
                            }
                        }
                        continue;
                    }
                    xArgs.add(obj);
                }
                if (marker != null) {
                    attribs.put(marker.getName(), marker);
                }
            }
        }
        return new LogRecord(origin, traceId, this.getLevel().getAvroLevel(), Instant.ofEpochMilli(this.getTimeStamp()), this.getLoggerName(), this.getThreadName(), this.getMessage(), xArgs, attribs == null ? Collections.EMPTY_MAP : attribs, extraThrowable == null ? null : Converters.convert(extraThrowable), (List)profiles);
    }
}

