/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Marker;
import org.spf4j.base.JsonWriteable;
import org.spf4j.base.Slf4jMessageFormatter;
import org.spf4j.base.Throwables;
import org.spf4j.io.AppendableWriter;
import org.spf4j.io.ObjectAppenderSupplier;
import org.spf4j.log.Level;
import org.spf4j.log.Slf4jLogRecord;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"LO_SUSPECT_LOG_PARAMETER"})
@ThreadSafe
public class Slf4jLogRecordImpl
implements JsonWriteable,
Slf4jLogRecord {
    private final String threadName;
    private final String loggerName;
    private final Level level;
    private final long timeStamp;
    private final Marker marker;
    private final String messageFormat;
    private final Object[] arguments;
    private volatile int startExtra;
    @Nullable
    private volatile String message;
    private volatile boolean isLogged;
    private Set<Object> attachments;

    public Slf4jLogRecordImpl(String logger, Level level, String format, Object ... arguments) {
        this(logger, level, null, format, arguments);
    }

    public Slf4jLogRecordImpl(String logger, Level level, @Nullable Marker marker, String format, Object ... arguments) {
        this(false, logger, level, marker, System.currentTimeMillis(), format, arguments);
    }

    public Slf4jLogRecordImpl(boolean isLogged, String logger, Level level, @Nullable Marker marker, String format, Object ... arguments) {
        this(isLogged, logger, level, marker, System.currentTimeMillis(), format, arguments);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public Slf4jLogRecordImpl(boolean isLogged, String logger, Level level, @Nullable Marker marker, long timestampMillis, String format, Object ... arguments) {
        this.loggerName = logger;
        this.level = level;
        this.timeStamp = timestampMillis;
        this.marker = marker;
        this.messageFormat = format;
        this.arguments = arguments;
        this.threadName = Thread.currentThread().getName();
        this.startExtra = -1;
        this.message = null;
        this.isLogged = isLogged;
        this.attachments = Collections.EMPTY_SET;
    }

    @Override
    public final String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public final Level getLevel() {
        return this.level;
    }

    @Override
    public final long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    @Nullable
    public final Marker getMarker() {
        return this.marker;
    }

    @Override
    public final String getMessageFormat() {
        return this.messageFormat;
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public final Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public final int getNrMessageArguments() {
        this.materializeMessage();
        return this.startExtra;
    }

    @Override
    public final String getThreadName() {
        return this.threadName;
    }

    @Override
    @Nonnull
    public final String getMessage() {
        this.materializeMessage();
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void materializeMessage() {
        if (this.message == null) {
            String string = this.messageFormat;
            synchronized (string) {
                if (this.message == null) {
                    StringBuilder sb = new StringBuilder(this.messageFormat.length() + this.arguments.length * 8);
                    try {
                        this.startExtra = Slf4jMessageFormatter.format(0, sb, this.messageFormat, ObjectAppenderSupplier.TO_STRINGER, this.arguments);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                    this.message = sb.toString();
                }
            }
        }
    }

    @Override
    @Nonnull
    public final Object[] getExtraArgumentsRaw() {
        this.materializeMessage();
        if (this.startExtra < this.arguments.length) {
            return Arrays.copyOfRange(this.arguments, this.startExtra, this.arguments.length);
        }
        return org.spf4j.base.Arrays.EMPTY_OBJ_ARRAY;
    }

    @Override
    @Nonnull
    public final Object[] getExtraArguments() {
        this.materializeMessage();
        if (this.startExtra < this.arguments.length) {
            int nrExtraThrowables = this.getNrExtraThrowables();
            if (nrExtraThrowables <= 0) {
                return Arrays.copyOfRange(this.arguments, this.startExtra, this.arguments.length);
            }
            Object[] result = new Object[this.arguments.length - this.startExtra - nrExtraThrowables];
            int i = 0;
            for (int j = this.startExtra; j < this.arguments.length; ++j) {
                Object argument = this.arguments[j];
                if (argument instanceof Throwable) continue;
                result[i++] = argument;
            }
            return result;
        }
        return org.spf4j.base.Arrays.EMPTY_OBJ_ARRAY;
    }

    private int getNrExtraThrowables() {
        this.materializeMessage();
        int count = 0;
        for (int i = this.startExtra; i < this.arguments.length; ++i) {
            Object argument = this.arguments[i];
            if (!(argument instanceof Throwable)) continue;
            ++count;
        }
        return count;
    }

    @Override
    @Nullable
    public final Throwable getExtraThrowable() {
        this.materializeMessage();
        Throwable result = null;
        for (int i = this.startExtra; i < this.arguments.length; ++i) {
            Object argument = this.arguments[i];
            if (!(argument instanceof Throwable)) continue;
            if (result == null) {
                result = (Throwable)argument;
                continue;
            }
            Throwables.suppressLimited(result, (Throwable)argument);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        this.writeTo(sb);
        return sb.toString();
    }

    @Override
    public void writeJsonTo(Appendable appendable) throws IOException {
        Throwable t;
        JsonGenerator gen = Lazy.JSON.createJsonGenerator((Writer)new AppendableWriter(appendable));
        gen.setCodec((ObjectCodec)Lazy.MAPPER);
        gen.writeStartObject();
        gen.writeFieldName("ts");
        gen.writeString(Instant.ofEpochMilli(this.timeStamp).toString());
        gen.writeFieldName("logger");
        gen.writeString(this.loggerName);
        gen.writeFieldName("thread");
        gen.writeString(this.threadName);
        gen.writeFieldName("msg");
        gen.writeString(this.getMessage());
        Object[] extraArguments = this.getExtraArguments();
        if (extraArguments.length > 0) {
            gen.writeFieldName("xObj");
            gen.writeStartArray();
            for (Object obj : extraArguments) {
                gen.writeObject(obj);
            }
            gen.writeEndArray();
        }
        if ((t = this.getExtraThrowable()) != null) {
            gen.writeFieldName("throwable");
            gen.writeString(Throwables.toString(t));
        }
        gen.writeEndObject();
        gen.flush();
    }

    @Override
    public final boolean isLogged() {
        return this.isLogged;
    }

    @Override
    public final void setIsLogged() {
        this.isLogged = true;
    }

    @Override
    public final synchronized void attach(Object obj) {
        if (this.attachments.isEmpty()) {
            this.attachments = new HashSet<Object>(2);
        }
        this.attachments.add(obj);
    }

    @Override
    public final synchronized boolean hasAttachment(Object obj) {
        return this.attachments.contains(obj);
    }

    @Override
    public final synchronized Set<Object> getAttachments() {
        return this.attachments.isEmpty() ? this.attachments : Collections.unmodifiableSet(this.attachments);
    }

    private static final class Lazy {
        private static final JsonFactory JSON = new JsonFactory();
        private static final ObjectMapper MAPPER = new ObjectMapper(JSON);

        private Lazy() {
        }
    }
}

