/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.net;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.TimeSource;
import org.spf4j.failsafe.RetryPolicy;
import org.spf4j.net.Timing;

@SuppressFBWarnings(value={"PREDICTABLE_RANDOM"})
public final class SntpClient {
    @VisibleForTesting
    static final int ORIGINATE_TIME_OFFSET = 24;
    @VisibleForTesting
    static final int RECEIVE_TIME_OFFSET = 32;
    @VisibleForTesting
    static final int TRANSMIT_TIME_OFFSET = 40;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int NTP_PORT = 123;
    private static final int NTP_MODE_CLIENT = 3;
    private static final int NTP_MODE_SERVER = 4;
    private static final int NTP_MODE_BROADCAST = 5;
    private static final int NTP_VERSION = 3;
    private static final int NTP_LEAP_NOSYNC = 3;
    private static final int NTP_STRATUM_DEATH = 0;
    private static final int NTP_STRATUM_MAX = 15;
    private static final long OFFSET_1900_TO_1970 = 2208988800L;
    private static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = Integer.getInteger("spf4j.sntpClient.defaultSocketTimeoutMillis", 5000);

    private SntpClient() {
    }

    public static Timing requestTimeHA(int timeoutMillis, String ... hosts) throws IOException, InterruptedException, TimeoutException {
        return SntpClient.requestTimeHA(timeoutMillis, DEFAULT_SOCKET_TIMEOUT_MILLIS, hosts);
    }

    public static Timing requestTimeHA(int timeoutMillis, int ntpResponseTimeoutMillis, String ... hosts) throws IOException, InterruptedException, TimeoutException {
        return SntpClient.requestTimeHA(timeoutMillis, ntpResponseTimeoutMillis, 123, hosts);
    }

    public static Timing requestTimeHA(int timeoutMillis, int ntpResponseTimeoutMillis, int port, String ... hosts) throws IOException, InterruptedException, TimeoutException {
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>(hosts.length * 2);
        for (String host : hosts) {
            for (InetAddress addr : InetAddress.getAllByName(host)) {
                addrs.add(addr);
            }
        }
        return SntpClient.requestTimeHA(timeoutMillis, ntpResponseTimeoutMillis, port, addrs.toArray(new InetAddress[addrs.size()]));
    }

    public static Timing requestTimeHA(int timeoutMillis, int ntpResponseTimeoutMillis, final int port, final InetAddress ... hosts) throws IOException, InterruptedException, TimeoutException {
        final long ntpResponseTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(ntpResponseTimeoutMillis);
        if (hosts.length <= 0) {
            throw new IllegalArgumentException("Must specify at least one host " + Arrays.toString(hosts));
        }
        try (final ExecutionContext ctx = ExecutionContexts.start("requestTimeHA", (long)timeoutMillis, TimeUnit.MILLISECONDS);){
            Timing timing = (Timing)RetryPolicy.defaultPolicy().call(new Callable<Timing>(){
                private int i;
                {
                    this.i = ThreadLocalRandom.current().nextInt(hosts.length);
                }

                @Override
                public Timing call() throws IOException {
                    long currTime;
                    int hostIdx = Math.abs(this.i++) % hosts.length;
                    long contextDe = ctx.getDeadlineNanos();
                    long deadline = ntpResponseTimeoutNanos > contextDe - (currTime = TimeSource.nanoTime()) ? contextDe : currTime + ntpResponseTimeoutNanos;
                    return SntpClient.requestTime(hosts[hostIdx], port, deadline);
                }
            }, IOException.class, ctx.getDeadlineNanos());
            return timing;
        }
    }

    public static synchronized Timing requestTime(String host, int timeoutMillis) throws IOException {
        return SntpClient.requestTime(host, 123, timeoutMillis);
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static Timing requestTime(String host, int port, int timeoutMillis) throws IOException {
        return SntpClient.requestTime(host, port, TimeSource.getDeadlineNanos(timeoutMillis, TimeUnit.MILLISECONDS));
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static Timing requestTime(String host, int port, long deadlineNanos) throws IOException {
        return SntpClient.requestTime(InetAddress.getByName(host), port, deadlineNanos);
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static synchronized Timing requestTime(InetAddress address, int port, long deadlineNanos) throws IOException {
        try (DatagramSocket socket = new DatagramSocket();){
            byte[] buffer = new byte[48];
            byte[] clientTime = new byte[8];
            DatagramPacket request = new DatagramPacket(buffer, buffer.length, address, port);
            buffer[0] = 27;
            DatagramPacket response = new DatagramPacket(buffer, buffer.length);
            long nanoTime = TimeSource.nanoTime();
            long requestTicks = nanoTime / 1000000L;
            long requestTime = System.currentTimeMillis();
            SntpClient.writeTimeStamp(clientTime, 0, requestTime);
            System.arraycopy(clientTime, 0, buffer, 40, 8);
            socket.send(request);
            long msToDeadline = deadlineNanos / 1000000L - requestTicks;
            if (msToDeadline <= 0L) {
                throw new SocketTimeoutException("deadline exceded by " + -msToDeadline + " ms");
            }
            socket.setSoTimeout((int)msToDeadline);
            socket.receive(response);
            if (!org.spf4j.base.Arrays.equals(clientTime, buffer, 0, 24, 0)) {
                throw new IllegalStateException("Packet with incorrect OriginateTime received " + Arrays.toString(buffer));
            }
            long responseTicks = TimeSource.nanoTime() / 1000000L;
            long roundTripMs = responseTicks - requestTicks;
            long responseTime = requestTime + roundTripMs;
            long originateTime = requestTime;
            long receiveTime = SntpClient.readTimeStamp(buffer, 32);
            long transmitTime = SntpClient.readTimeStamp(buffer, 40);
            byte leap = (byte)(buffer[0] >> 6 & 3);
            byte mode = (byte)(buffer[0] & 7);
            int stratum = buffer[1] & 0xFF;
            SntpClient.checkValidServerReply(leap, mode, stratum, transmitTime);
            long roundTripTime = roundTripMs - (transmitTime - receiveTime);
            long clockOffset = (receiveTime - originateTime + (transmitTime - responseTime)) / 2L;
            Timing timing = new Timing(responseTime + clockOffset, responseTicks, roundTripTime);
            return timing;
        }
    }

    private static void checkValidServerReply(byte leap, byte mode, int stratum, long transmitTime) {
        if (leap == 3) {
            throw new IllegalStateException("Unsynchronized server: " + leap);
        }
        if (mode != 4 && mode != 5) {
            throw new IllegalStateException("Untrusted mode: " + mode);
        }
        if (stratum == 0 || stratum > 15) {
            throw new IllegalStateException("Untrusted stratum: " + stratum);
        }
        if (transmitTime == 0L) {
            throw new IllegalStateException("Zero transmitTime: " + transmitTime);
        }
    }

    private static long read32(byte[] buffer, int offset) {
        int b0 = buffer[offset];
        int b1 = buffer[offset + 1];
        int b2 = buffer[offset + 2];
        int b3 = buffer[offset + 3];
        int i0 = (b0 & 0x80) == 128 ? (b0 & 0x7F) + 128 : b0;
        int i1 = (b1 & 0x80) == 128 ? (b1 & 0x7F) + 128 : b1;
        int i2 = (b2 & 0x80) == 128 ? (b2 & 0x7F) + 128 : b2;
        int i3 = (b3 & 0x80) == 128 ? (b3 & 0x7F) + 128 : b3;
        return ((long)i0 << 24) + ((long)i1 << 16) + ((long)i2 << 8) + (long)i3;
    }

    @VisibleForTesting
    static long readTimeStamp(byte[] buffer, int offset) {
        long seconds = SntpClient.read32(buffer, offset);
        long fraction = SntpClient.read32(buffer, offset + 4);
        return (seconds - 2208988800L) * 1000L + fraction * 1000L / 0x100000000L;
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"})
    @VisibleForTesting
    static void writeTimeStamp(byte[] buffer, int poffset, long time) {
        int offset = poffset;
        long seconds = time / 1000L;
        long milliseconds = time % 1000L;
        buffer[offset++] = (byte)((seconds += 2208988800L) >> 24);
        buffer[offset++] = (byte)(seconds >> 16);
        buffer[offset++] = (byte)(seconds >> 8);
        buffer[offset++] = (byte)seconds;
        long fraction = milliseconds * 0x100000000L / 1000L;
        buffer[offset++] = (byte)(fraction >> 24);
        buffer[offset++] = (byte)(fraction >> 16);
        buffer[offset++] = (byte)(fraction >> 8);
        buffer[offset] = (byte)ThreadLocalRandom.current().nextInt(256);
    }
}

