/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.os;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.spf4j.os.ProcessHandler;
import org.spf4j.os.ProcessUtil;

@SuppressFBWarnings(value={"LO_SUSPECT_LOG_PARAMETER"})
public final class LoggingProcessHandler
implements ProcessHandler<Void, Void> {
    private Logger log;

    public LoggingProcessHandler(Logger log) {
        this.log = log;
    }

    @Override
    public void started(Process p) {
        int pid = ProcessUtil.getPid(p);
        this.log.log(Level.FINE, "Started {0} with pid={1} ", new Object[]{p, pid});
        this.log = Logger.getLogger(this.log.getName() + '.' + pid);
    }

    @Override
    @Nullable
    public Void handleStdOut(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));
        while ((line = reader.readLine()) != null) {
            this.log.fine(line);
        }
        return null;
    }

    @Override
    @Nullable
    public Void handleStdErr(InputStream stderr) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stderr, Charset.defaultCharset()));
        while ((line = reader.readLine()) != null) {
            this.log.severe(line);
        }
        return null;
    }

    public String toString() {
        return "LoggingProcessHandler{log=" + this.log + '}';
    }
}

