/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.os;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.management.UnixOperatingSystemMXBean;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.spf4j.base.JNA;
import org.spf4j.base.SysExits;
import org.spf4j.base.TimeSource;
import org.spf4j.os.LoggingProcessHandler;
import org.spf4j.os.ProcessHandler;
import org.spf4j.os.ProcessResponse;
import org.spf4j.os.ProcessUtil;
import org.spf4j.os.StdOutToStringProcessHandler;
import org.spf4j.unix.CLibrary;
import org.spf4j.unix.Lsof;
import org.spf4j.unix.UnixException;
import org.spf4j.unix.UnixResources;
import org.spf4j.unix.UnixRuntimeException;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public final class OperatingSystem {
    private static final Logger LOG;
    private static final long ABORT_TIMEOUT_MILLIS;
    private static final Path FD_FOLDER;
    private static final OperatingSystemMXBean OS_MBEAN;
    private static final com.sun.management.OperatingSystemMXBean SUN_OS_MBEAN;
    private static final UnixOperatingSystemMXBean UNIX_OS_MBEAN;
    public static final long MAX_NR_OPENFILES;
    private static final boolean IS_MAC_OSX;
    private static final boolean IS_WINDOWS;
    private static final String OS_NAME;

    private OperatingSystem() {
    }

    public static boolean isMacOsx() {
        return IS_MAC_OSX;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static String getOsName() {
        return OS_NAME;
    }

    public static OperatingSystemMXBean getOSMbean() {
        return OS_MBEAN;
    }

    @Nullable
    public static com.sun.management.OperatingSystemMXBean getSunJdkOSMBean() {
        return SUN_OS_MBEAN;
    }

    @Nullable
    public static UnixOperatingSystemMXBean getUnixOsMBean() {
        return UNIX_OS_MBEAN;
    }

    public static long getOpenFileDescriptorCount() {
        if (UNIX_OS_MBEAN != null) {
            return UNIX_OS_MBEAN.getOpenFileDescriptorCount();
        }
        try {
            if (OperatingSystem.isMacOsx()) {
                try {
                    return Lsof.getNrOpenFiles();
                }
                catch (ExecutionException | TimeoutException ex) {
                    LOG.log(Level.WARNING, "Unable to get nr of open files", ex);
                    return -1L;
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.WARNING, "Unable to get nr of open files", ex);
                    Thread.currentThread().interrupt();
                    return -1L;
                }
            }
            if (Files.isDirectory(FD_FOLDER, new LinkOption[0])) {
                int result = 0;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(FD_FOLDER);){
                    Iterator<Path> iterator = stream.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        ++result;
                    }
                }
                return result;
            }
            return -1L;
        }
        catch (IOException ex) {
            String msg = ex.getMessage();
            if (msg != null && msg.contains("Too many open files")) {
                return OperatingSystem.getMaxFileDescriptorCount();
            }
            LOG.log(Level.WARNING, "Unable to get nr of open files", ex);
            return -1L;
        }
    }

    public static String getHostName() {
        if (Platform.isWindows()) {
            return Kernel32Util.getComputerName();
        }
        byte[] hostnameBuffer = new byte[257];
        int result = CLibrary.INSTANCE.gethostname(hostnameBuffer, hostnameBuffer.length);
        if (result != 0) {
            int lastError = Native.getLastError();
            throw new UnixRuntimeException("Error code " + CLibrary.INSTANCE.strerror(lastError) + " for gethostname(byyte[], 256)", lastError);
        }
        return Native.toString((byte[])hostnameBuffer);
    }

    public static long getMaxFileDescriptorCount() {
        return MAX_NR_OPENFILES;
    }

    public static int killProcess(Process proc, long terminateTimeoutMillis, long forceTerminateTimeoutMillis) throws InterruptedException, TimeoutException {
        proc.destroy();
        if (proc.waitFor(terminateTimeoutMillis, TimeUnit.MILLISECONDS)) {
            return proc.exitValue();
        }
        proc.destroyForcibly();
        if (!proc.waitFor(forceTerminateTimeoutMillis, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Cannot terminate " + proc);
        }
        return proc.exitValue();
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"COMMAND_INJECTION", "CC_CYCLOMATIC_COMPLEXITY"})
    public static <T, E> ProcessResponse<T, E> forkExec(String[] command, ProcessHandler<T, E> handler, long timeoutMillis, long terminationTimeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
    private static int waitFor(AtomicReference<Throwable> exr, Process process, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long startTime = TimeSource.nanoTime();
        long rem = unit.toNanos(timeout);
        while (true) {
            try {
                return process.exitValue();
            }
            catch (IllegalThreadStateException ex) {
                if (rem > 0L) {
                    Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                }
                rem = unit.toNanos(timeout) - (TimeSource.nanoTime() - startTime);
                Throwable get = exr.get();
                if (get == null) continue;
                throw new ExecutionException(get);
                if (rem > 0L) continue;
                throw new TimeoutException("Process " + process + " timed out after " + timeout + " " + (Object)((Object)unit));
            }
            break;
        }
    }

    @CheckReturnValue
    public static String forkExec(String[] command, long timeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        ProcessResponse<String, String> resp = OperatingSystem.forkExec(command, new StdOutToStringProcessHandler(), timeoutMillis, 60000L);
        if (resp.getResponseExitCode() != SysExits.OK) {
            throw new ExecutionException("Failed to execute " + Arrays.toString(command) + ", exitCode = " + resp.getResponseCode() + ", stderr = " + resp.getErrOutput(), null);
        }
        return resp.getOutput();
    }

    public static void forkExecLog(String[] command, long timeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        ProcessResponse<Void, Void> resp = OperatingSystem.forkExec(command, new LoggingProcessHandler(Logger.getLogger("fork." + command[0])), timeoutMillis, 60000L);
        if (resp.getResponseExitCode() != SysExits.OK) {
            throw new ExecutionException("Failed to execute " + Arrays.toString(command) + ", exitCode = " + resp.getResponseCode() + ", stderr = " + resp.getErrOutput(), null);
        }
    }

    private static /* synthetic */ Object lambda$forkExec$1(ProcessHandler handler, InputStream pos, AtomicReference eex) throws Exception {
        try {
            return handler.handleStdOut(pos);
        }
        catch (Throwable t) {
            eex.set(t);
            throw t;
        }
    }

    private static /* synthetic */ Object lambda$forkExec$0(ProcessHandler handler, InputStream pes, AtomicReference eex) throws Exception {
        try {
            return handler.handleStdErr(pes);
        }
        catch (Throwable t) {
            eex.set(t);
            throw t;
        }
    }

    static {
        String osName;
        LOG = Logger.getLogger(OperatingSystem.class.getName());
        ABORT_TIMEOUT_MILLIS = Long.getLong("spf4j.os.abortTimeoutMillis", 5000L);
        FD_FOLDER = Paths.get("/proc/" + ProcessUtil.getPid() + "/fd", new String[0]);
        OS_NAME = osName = System.getProperty("os.name");
        IS_MAC_OSX = "Mac OS X".equals(osName);
        IS_WINDOWS = osName.startsWith("Windows");
        OS_MBEAN = ManagementFactory.getOperatingSystemMXBean();
        SUN_OS_MBEAN = OS_MBEAN instanceof com.sun.management.OperatingSystemMXBean ? (com.sun.management.OperatingSystemMXBean)OS_MBEAN : null;
        if (OS_MBEAN instanceof UnixOperatingSystemMXBean) {
            UNIX_OS_MBEAN = (UnixOperatingSystemMXBean)OS_MBEAN;
            MAX_NR_OPENFILES = UNIX_OS_MBEAN.getMaxFileDescriptorCount();
        } else {
            UNIX_OS_MBEAN = null;
            if (IS_WINDOWS) {
                MAX_NR_OPENFILES = Integer.MAX_VALUE;
            } else if (JNA.haveJnaPlatformClib()) {
                try {
                    MAX_NR_OPENFILES = UnixResources.RLIMIT_NOFILE.getSoftLimit();
                }
                catch (UnixException ex) {
                    throw new ExceptionInInitializerError(ex);
                }
            } else {
                MAX_NR_OPENFILES = Integer.MAX_VALUE;
            }
        }
    }
}

