/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.os;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import javax.annotation.Signed;
import org.spf4j.base.UncheckedExecutionException;
import org.spf4j.os.OperatingSystem;

public final class ProcessUtil {
    private static final int PID = ProcessUtil.parsePid();

    private ProcessUtil() {
    }

    private static int parsePid() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        String mxBeanName = runtimeMxBean.getName();
        int atIdx = mxBeanName.indexOf(64);
        if (atIdx < 0) {
            return -1;
        }
        return Integer.parseInt(mxBeanName.substring(0, atIdx));
    }

    @Signed
    public static int getPid() {
        return PID;
    }

    public static int getPid(Process p) {
        if (OperatingSystem.isWindows()) {
            return ProcessUtil.getWindowsPid(p);
        }
        return ProcessUtil.getUnixPid(p);
    }

    private static int getUnixPid(Process p) {
        try {
            Field pidF = p.getClass().getDeclaredField("pid");
            pidF.setAccessible(true);
            return pidF.getInt(p);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            throw new UncheckedExecutionException("Cannot get PID for " + p, ex);
        }
    }

    private static int getWindowsPid(Process p) {
        long lHandle;
        try {
            Field f = p.getClass().getDeclaredField("handle");
            f.setAccessible(true);
            lHandle = f.getLong(p);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            throw new UncheckedExecutionException("Cannot get PID for " + p, ex);
        }
        Kernel32 kernel = Kernel32.INSTANCE;
        WinNT.HANDLE handle = new WinNT.HANDLE();
        handle.setPointer(Pointer.createConstant((long)lHandle));
        return kernel.GetProcessId(handle);
    }
}

