/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.os;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.spf4j.base.Strings;
import org.spf4j.os.ProcessHandler;
import org.spf4j.os.ProcessUtil;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public final class StdOutToStringProcessHandler
implements ProcessHandler<String, String> {
    private Logger log = Logger.getLogger(StdOutToStringProcessHandler.class.getName());

    @Override
    public void started(Process p) {
        int pid = ProcessUtil.getPid(p);
        this.log.log(Level.FINE, "Started {0} with pid={1} ", new Object[]{p, pid});
        this.log = Logger.getLogger(this.log.getName() + '.' + pid);
    }

    @Override
    public String handleStdOut(InputStream stdout) throws IOException {
        String line;
        StringBuilder result = new StringBuilder(128);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stdout, Charset.defaultCharset()));
        while ((line = reader.readLine()) != null) {
            this.log.fine(line);
            result.append(line).append(Strings.EOL);
        }
        this.log.fine("done with stdout");
        return result.toString();
    }

    @Override
    public String handleStdErr(InputStream stderr) throws IOException {
        String line;
        StringBuilder result = new StringBuilder(128);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stderr, Charset.defaultCharset()));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("INFO")) {
                this.log.info(line);
            } else if (line.startsWith("WARN")) {
                this.log.warning(line);
            } else {
                this.log.severe(line);
            }
            result.append(line).append(Strings.EOL);
        }
        this.log.fine("done with stderr");
        return result.toString();
    }

    public String toString() {
        return "StdOutToStringProcessHandler{log=" + this.log + '}';
    }
}

