/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.spf4j.base.avro.AvroCloseableIterable;
import org.spf4j.perf.TimeSeriesAggregatingIterator;
import org.spf4j.perf.TimeSeriesRecord;
import org.spf4j.tsdb2.TableDefs;
import org.spf4j.tsdb2.avro.Observation;

public interface MeasurementStoreQuery {
    public Collection<Schema> getMeasurements(Predicate<String> var1) throws IOException;

    public AvroCloseableIterable<Observation> getObservations() throws IOException;

    default public AvroCloseableIterable<Observation> getObservations(Schema measurement, @Nullable Instant from, @Nullable Instant to) throws IOException {
        Collection mids = (Collection)measurement.getObjectProp("ids");
        long fromMs = from == null ? Long.MIN_VALUE : from.toEpochMilli();
        long toMs = to == null ? Long.MAX_VALUE : to.toEpochMilli();
        AvroCloseableIterable<Observation> observations = this.getObservations();
        Iterable filtered = Iterables.filter(observations, row -> {
            long ts = row.getRelTimeStamp();
            return ts >= fromMs && ts <= toMs && mids.contains(row.getTableDefId());
        });
        return AvroCloseableIterable.from(filtered, observations, measurement);
    }

    default public AvroCloseableIterable<Observation> getAggregatedObservations(Schema measurement, Instant from, Instant to, int aggFreq, TimeUnit tu) throws IOException {
        long aggTime = tu.toMillis(aggFreq);
        int frequencyMillis = TimeSeriesRecord.getFrequencyMillis(measurement);
        AvroCloseableIterable<Observation> observations = this.getObservations(measurement, from, to);
        return AvroCloseableIterable.from(() -> new TimeSeriesAggregatingIterator<Observation>(observations, Observation::getRelTimeStamp, (a, b) -> TimeSeriesRecord.accumulateObservations(measurement, a, b), aggTime, frequencyMillis), observations, measurement);
    }

    default public AvroCloseableIterable<TimeSeriesRecord> getMeasurementData(Schema measurement, Instant from, Instant to) throws IOException {
        AvroCloseableIterable<Observation> observations = this.getObservations(measurement, from, to);
        Iterable tsr = Iterables.transform(observations, obs -> TableDefs.toRecord(measurement, obs));
        return AvroCloseableIterable.from(tsr, observations, measurement);
    }

    @Beta
    default public AvroCloseableIterable<TimeSeriesRecord> getAggregatedMeasurementData(Schema measurement, Instant from, Instant to, int aggFreq, TimeUnit tu) throws IOException {
        long aggTime = tu.toMillis(aggFreq);
        int frequencyMillis = TimeSeriesRecord.getFrequencyMillis(measurement);
        AvroCloseableIterable<TimeSeriesRecord> iterable = this.getMeasurementData(measurement, from, to);
        return AvroCloseableIterable.from(() -> new TimeSeriesAggregatingIterator<TimeSeriesRecord>(iterable, rec -> rec.getTimeStamp().toEpochMilli(), TimeSeriesRecord::accumulate, aggTime, frequencyMillis), iterable, measurement);
    }
}

