/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.TimeSource;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.MeasurementRecorderSource;
import org.spf4j.perf.impl.NopMeasurementRecorder;

public final class PerformanceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(PerformanceMonitor.class);

    private PerformanceMonitor() {
    }

    public static <T> T callAndMonitor(long warnMillis, long errorMillis, Callable<T> callable) throws Exception {
        return PerformanceMonitor.performanceMonitoredCallable(warnMillis, errorMillis, callable).call();
    }

    public static <T> T callAndMonitor(MeasurementRecorderSource mrs, long warnMillis, long errorMillis, Callable<T> callable) throws Exception {
        return PerformanceMonitor.performanceMonitoredCallable(mrs, warnMillis, errorMillis, callable).call();
    }

    public static <T> T callAndMonitor(MeasurementRecorderSource mrs, long warnMillis, long errorMillis, Callable<T> callable, boolean isLogInfo, Object ... detail) throws Exception {
        return PerformanceMonitor.performanceMonitoredCallable(mrs, warnMillis, errorMillis, callable, isLogInfo, detail).call();
    }

    public static <T> Callable<T> performanceMonitoredCallable(MeasurementRecorderSource mrs, long warnMillis, long errorMillis, Callable<T> callable) {
        return PerformanceMonitor.performanceMonitoredCallable(mrs, warnMillis, errorMillis, callable, false, new Object[0]);
    }

    public static <T> Callable<T> performanceMonitoredCallable(final MeasurementRecorderSource mrs, final long warnMillis, final long errorMillis, final Callable<T> callable, final boolean isLogInfo, final Object ... detail) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                long start = TimeSource.nanoTime();
                Object result = callable.call();
                long elapsed = TimeUnit.NANOSECONDS.toMillis(TimeSource.nanoTime() - start);
                String callableName = callable.toString();
                mrs.getRecorder(callableName).record(elapsed);
                if (elapsed > warnMillis) {
                    if (elapsed > errorMillis) {
                        LOG.error("Execution time  {} ms for {} exceeds error threshold of {} ms, detail: {}", new Object[]{elapsed, callableName, errorMillis, detail});
                    } else {
                        LOG.warn("Execution time  {} ms for {} exceeds warning threshold of {} ms, detail: {}", new Object[]{elapsed, callableName, warnMillis, detail});
                    }
                } else if (isLogInfo) {
                    LOG.info("Execution time {} ms for {}, detail: {}", new Object[]{elapsed, callableName, detail});
                } else {
                    LOG.debug("Execution time {} ms for {}, detail: {}", new Object[]{elapsed, callableName, detail});
                }
                return result;
            }
        };
    }

    public static <T> Callable<T> performanceMonitoredCallable(long warnMillis, long errorMillis, Callable<T> callable) {
        return PerformanceMonitor.performanceMonitoredCallable(NopMeasurementRecorder.INSTANCE, warnMillis, errorMillis, callable, false, new Object[0]);
    }

    public static <T> Callable<T> performanceMonitoredCallable(long warnMillis, long errorMillis, Callable<T> callable, boolean isLogInfo, Object ... detail) {
        return PerformanceMonitor.performanceMonitoredCallable(NopMeasurementRecorder.INSTANCE, warnMillis, errorMillis, callable, isLogInfo, detail);
    }

    public static <T> Callable<T> performanceMonitoredCallable(final MeasurementRecorder mr, final long warnMillis, final long errorMillis, final Callable<T> callable, final boolean isLogInfo, final Object ... detail) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                long start = System.currentTimeMillis();
                Object result = callable.call();
                long elapsed = System.currentTimeMillis() - start;
                mr.record(elapsed);
                String callableName = callable.toString();
                if (elapsed > warnMillis) {
                    if (elapsed > errorMillis) {
                        LOG.error("Execution time  {} ms for {} exceeds error threshold of {} ms, detail: {}", new Object[]{elapsed, callableName, errorMillis, detail});
                    } else {
                        LOG.warn("Execution time  {} ms for {} exceeds warning threshold of {} ms, detail: {}", new Object[]{elapsed, callableName, warnMillis, detail});
                    }
                } else if (isLogInfo) {
                    LOG.info("Execution time {} ms for {}, detail: {}", new Object[]{elapsed, callableName, detail});
                } else {
                    LOG.debug("Execution time {} ms for {}, detail: {}", new Object[]{elapsed, callableName, detail});
                }
                return result;
            }
        };
    }
}

