/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf;

import org.spf4j.perf.cpu.CpuUsageSampler;
import org.spf4j.perf.cpu.ThreadUsageSampler;
import org.spf4j.perf.io.OpenFilesSampler;
import org.spf4j.perf.memory.GCUsageSampler;
import org.spf4j.perf.memory.MemoryUsageSampler;

public final class ProcessVitals
implements AutoCloseable {
    private final int openFilesSampleTimeMillis;
    private final int memoryUseSampleTimeMillis;
    private final int gcUseSampleTimeMillis;
    private final int threadUseSampleTimeMillis;
    private final int cpuUseSampleTimeMillis;

    public ProcessVitals() {
        this(Integer.getInteger("spf4j.vitals.openFilesSampleTimeMillis", 60000), Integer.getInteger("spf4j.vitals.memoryUseSampleTimeMillis", 6000), Integer.getInteger("spf4j.vitals.gcUseSampleTimeMillis", 10000), Integer.getInteger("spf4j.vitals.threadUseSampleTimeMillis", 10000), Integer.getInteger("spf4j.vitals.cpuUseSampleTimeMillis", 10000));
    }

    public ProcessVitals(int openFilesSampleTimeMillis, int memoryUseSampleTimeMillis, int gcUseSampleTimeMillis, int threadUseSampleTimeMillis, int cpuUseSampleTimeMillis) {
        this.openFilesSampleTimeMillis = openFilesSampleTimeMillis;
        this.memoryUseSampleTimeMillis = memoryUseSampleTimeMillis;
        this.gcUseSampleTimeMillis = gcUseSampleTimeMillis;
        this.threadUseSampleTimeMillis = threadUseSampleTimeMillis;
        this.cpuUseSampleTimeMillis = cpuUseSampleTimeMillis;
    }

    public void start() {
        OpenFilesSampler.start(this.openFilesSampleTimeMillis);
        MemoryUsageSampler.start(this.memoryUseSampleTimeMillis);
        GCUsageSampler.start(this.gcUseSampleTimeMillis);
        ThreadUsageSampler.start(this.threadUseSampleTimeMillis);
        CpuUsageSampler.start(this.cpuUseSampleTimeMillis);
    }

    @Override
    public void close() {
        OpenFilesSampler.stop();
        MemoryUsageSampler.stop();
        GCUsageSampler.stop();
        ThreadUsageSampler.stop();
        CpuUsageSampler.stop();
    }

    public String toString() {
        return "ProcessVitals{openFilesSampleTimeMillis=" + this.openFilesSampleTimeMillis + ", memoryUseSampleTimeMillis=" + this.memoryUseSampleTimeMillis + ", gcUseSampleTimeMillis=" + this.gcUseSampleTimeMillis + ", threadUseSampleTimeMillis=" + this.threadUseSampleTimeMillis + ", cpuUseSampleTimeMillis=" + this.cpuUseSampleTimeMillis + '}';
    }
}

