/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.ToLongFunction;

public final class TimeSeriesAggregatingIterator<T>
implements Iterator<T> {
    private final long aggTime;
    private final PeekingIterator<T> it;
    private T rec;
    private long maxTime;
    private final ToLongFunction<T> timeExtractor;
    private final BiConsumer<T, T> accumulator;
    private final int adj;

    public TimeSeriesAggregatingIterator(Iterable<T> dataStream, ToLongFunction<T> timeExtractor, BiConsumer<T, T> accumulator, long aggTime, int sampleTime) {
        this.aggTime = aggTime;
        this.it = Iterators.peekingIterator(dataStream.iterator());
        this.timeExtractor = timeExtractor;
        this.accumulator = accumulator;
        this.adj = Math.max(sampleTime, 0) / 2;
        this.aggNext();
    }

    private void aggNext() {
        if (this.it.hasNext()) {
            Object next;
            this.rec = this.it.next();
            long recTime = this.timeExtractor.applyAsLong(this.rec);
            this.maxTime = recTime + this.aggTime - (long)this.adj;
            while (this.it.hasNext() && (recTime = this.timeExtractor.applyAsLong(next = this.it.peek())) < this.maxTime) {
                this.accumulator.accept(this.rec, next);
                this.it.next();
            }
        } else {
            this.rec = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.rec != null;
    }

    @Override
    public T next() {
        if (this.rec == null) {
            throw new NoSuchElementException();
        }
        T result = this.rec;
        this.aggNext();
        return result;
    }

    public String toString() {
        return "TimeSeriesAggregatingIterator{aggTime=" + this.aggTime + ", it=" + this.it + ", rec=" + this.rec + ", maxTime=" + this.maxTime + '}';
    }
}

