/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf;

import com.google.common.annotations.Beta;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.spf4j.tsdb2.avro.Aggregation;
import org.spf4j.tsdb2.avro.Observation;

public interface TimeSeriesRecord
extends GenericRecord {
    public static final String MEASUREMENT_TYPE_PROP = "measurementType";
    public static final String AGGREGATION_TYPE_PROP = "aggregation";
    public static final String UNIT_TYPE_PROP = "unit";
    public static final String FREQ_MILLIS_REC_PROP = "frequencyMillis";
    public static final String RAW_NAME = "rawName";
    public static final String IDS_PROP = "ids";

    public Instant getTimeStamp();

    public long getLongValue(String var1);

    public double getDoubleValue(String var1);

    public static int getFrequencyMillis(Schema schema) {
        Number freq = (Number)schema.getObjectProp(FREQ_MILLIS_REC_PROP);
        if (freq == null) {
            return -1;
        }
        return freq.intValue();
    }

    public static String getUnit(Schema schema) {
        String unit = (String)schema.getObjectProp(UNIT_TYPE_PROP);
        if (unit == null) {
            return "N/A";
        }
        return unit;
    }

    public static TimeSeriesRecord from(final GenericRecord rec) {
        return new TimeSeriesRecord(){

            @Override
            public Instant getTimeStamp() {
                return (Instant)rec.get(0);
            }

            @Override
            public long getLongValue(String column) {
                return ((Number)rec.get(column)).longValue();
            }

            @Override
            public double getDoubleValue(String column) {
                return ((Number)rec.get(column)).doubleValue();
            }

            public void put(String key, Object v) {
                rec.put(key, v);
            }

            public Object get(String key) {
                return rec.get(key);
            }

            public void put(int i, Object v) {
                rec.put(i, v);
            }

            public Object get(int i) {
                return rec.get(i);
            }

            public Schema getSchema() {
                return rec.getSchema();
            }
        };
    }

    @Beta
    default public void accumulate(TimeSeriesRecord r2) {
        Schema recSchema = this.getSchema();
        Iterator it = recSchema.getFields().iterator();
        it.next();
        this.put(0, r2.get(0));
        block7: while (it.hasNext()) {
            Schema.Field nf = (Schema.Field)it.next();
            int pos = nf.pos();
            String prop = nf.schema().getProp(AGGREGATION_TYPE_PROP);
            Aggregation agg = prop != null ? Aggregation.valueOf((String)prop) : TimeSeriesRecord.inferAggregationFromName(nf, recSchema);
            switch (agg) {
                case SUM: {
                    this.put(pos, (Long)this.get(pos) + (Long)r2.get(pos));
                    continue block7;
                }
                case MIN: {
                    this.put(pos, Math.min((Long)this.get(pos), (Long)r2.get(pos)));
                    continue block7;
                }
                case MAX: {
                    this.put(pos, Math.max((Long)this.get(pos), (Long)r2.get(pos)));
                    continue block7;
                }
                case FIRST: {
                    continue block7;
                }
                case LAST: 
                case UNKNOWN: {
                    this.put(pos, (Long)r2.get(pos));
                    continue block7;
                }
            }
            throw new UnsupportedOperationException("Unsupported aggregation: " + agg);
        }
    }

    @Beta
    public static void accumulateObservations(Schema recSchema, Observation r1, Observation r2) {
        r1.setRelTimeStamp(r2.getRelTimeStamp());
        r1.setTableDefId(-1L);
        Iterator it = recSchema.getFields().iterator();
        it.next();
        List r1d = r1.getData();
        List r2d = r2.getData();
        block7: while (it.hasNext()) {
            Schema.Field nf = (Schema.Field)it.next();
            int pos = nf.pos();
            String prop = nf.schema().getProp(AGGREGATION_TYPE_PROP);
            Aggregation agg = prop != null ? Aggregation.valueOf((String)prop) : TimeSeriesRecord.inferAggregationFromName(nf, recSchema);
            int apos = pos - 1;
            switch (agg) {
                case SUM: {
                    r1d.set(apos, (Long)r1d.get(apos) + (Long)r2d.get(apos));
                    continue block7;
                }
                case MIN: {
                    r1d.set(apos, Math.min((Long)r1d.get(apos), (Long)r2d.get(apos)));
                    continue block7;
                }
                case MAX: {
                    r1d.set(apos, Math.max((Long)r1d.get(apos), (Long)r2d.get(apos)));
                    continue block7;
                }
                case FIRST: {
                    continue block7;
                }
                case LAST: 
                case UNKNOWN: {
                    r1d.set(apos, r2d.get(apos));
                    continue block7;
                }
            }
            throw new UnsupportedOperationException("Unsupported aggregation: " + agg);
        }
    }

    public static Aggregation inferAggregationFromName(Schema.Field nf, Schema recSchema) {
        Aggregation agg;
        block6 : switch (nf.name()) {
            case "count": 
            case "total": {
                agg = Aggregation.SUM;
                break;
            }
            case "min": {
                agg = Aggregation.MIN;
                break;
            }
            case "max": {
                agg = Aggregation.MAX;
                break;
            }
            default: {
                String mType = recSchema.getProp(MEASUREMENT_TYPE_PROP);
                if (mType != null) {
                    switch (mType) {
                        case "COUNTER": 
                        case "SUMMARY": {
                            agg = Aggregation.SUM;
                            break block6;
                        }
                    }
                    agg = Aggregation.LAST;
                    break;
                }
                agg = Aggregation.LAST;
            }
        }
        return agg;
    }
}

