/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.cpu;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.base.Threads;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.io.ByteArrayBuilder;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.impl.RecorderFactory;

public final class ThreadUsageSampler {
    private static final ThreadMXBean TH_BEAN = ManagementFactory.getThreadMXBean();
    private static ScheduledFuture<?> samplingFuture;
    private static final List<String> PEAK_THREAD_NAMES;
    private static final List<StackTraceElement[]> PEAK_THREAD_TRACES;
    private static final BitSet PEAK_THREAD_DAEMON;
    private static Instant peakTime;

    private ThreadUsageSampler() {
    }

    public static synchronized void writePeakThreadInfo(PrintStream out) {
        if (!PEAK_THREAD_NAMES.isEmpty()) {
            out.println("Peak Threads:");
            int i = 0;
            boolean haveStacktraces = !PEAK_THREAD_TRACES.isEmpty();
            for (String tname : PEAK_THREAD_NAMES) {
                out.print(tname);
                out.print(", daemon =");
                out.print(PEAK_THREAD_DAEMON.get(i));
                out.print(',');
                if (haveStacktraces) {
                    out.print(' ');
                    out.print(Arrays.toString(PEAK_THREAD_TRACES.get(i)));
                }
                out.println();
                ++i;
            }
        }
    }

    public static synchronized void logPeakThreadInfo(Level level) {
        if (!PEAK_THREAD_NAMES.isEmpty()) {
            Logger logger = Logger.getLogger(ThreadUsageSampler.class.getName());
            int i = 0;
            for (String tname : PEAK_THREAD_NAMES) {
                logger.log(level, "PeakThread({0}), daemon={1}, trace -> {2}", new Object[]{tname, PEAK_THREAD_DAEMON.get(i), Arrays.toString(PEAK_THREAD_TRACES.get(i))});
                ++i;
            }
        }
    }

    @JmxExport
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING", "NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static String getPeakThreadInfo() {
        try (ByteArrayBuilder bab = new ByteArrayBuilder();){
            PrintStream ps = new PrintStream(bab);
            ThreadUsageSampler.writePeakThreadInfo(ps);
            String string = bab.toString(Charset.defaultCharset());
            return string;
        }
    }

    @JmxExport
    public static synchronized void clearPeakThreadInfo() {
        PEAK_THREAD_NAMES.clear();
        PEAK_THREAD_TRACES.clear();
        PEAK_THREAD_DAEMON.clear();
        peakTime = null;
    }

    @JmxExport
    @Nullable
    public static synchronized String getPeakTime() {
        if (peakTime == null) {
            return null;
        }
        return peakTime.toString();
    }

    @JmxExport
    public static String getCurrentAliveThreadInfo() {
        StringBuilder sb = new StringBuilder(2048);
        Thread[] threads = Threads.getThreads();
        StackTraceElement[][] stackTraces = Threads.getStackTraces(threads);
        for (int i = 0; i < threads.length; ++i) {
            Thread t = threads[i];
            if (!t.isAlive()) continue;
            sb.append(t.getId());
            sb.append(",\t").append(t.getName());
            sb.append(",\t state =").append((Object)t.getState());
            sb.append(",\t daemon =").append(t.isDaemon());
            sb.append(",\t");
            Object[] straces = stackTraces[i];
            if (straces != null && straces.length > 0) {
                sb.append(' ');
                sb.append(Arrays.toString(straces));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static synchronized void start(int sampleTime) {
        ThreadUsageSampler.start(sampleTime, true);
    }

    @JmxExport
    public static synchronized void start(@JmxExport(value="sampleTimeMillis") int sampleTime, @JmxExport(value="withStackTraces") boolean withStackTraces) {
        if (samplingFuture != null) {
            throw new IllegalStateException("Thread sampling already started " + samplingFuture);
        }
        samplingFuture = DefaultScheduler.INSTANCE.scheduleWithFixedDelay(new ThreadStateRecorder(sampleTime, withStackTraces), sampleTime, sampleTime, TimeUnit.MILLISECONDS);
    }

    @JmxExport
    public static synchronized void stop() {
        if (samplingFuture != null) {
            samplingFuture.cancel(false);
            samplingFuture = null;
        }
    }

    @JmxExport
    public static synchronized boolean isStarted() {
        return samplingFuture != null;
    }

    static {
        PEAK_THREAD_NAMES = new ArrayList<String>();
        PEAK_THREAD_TRACES = new ArrayList<StackTraceElement[]>();
        PEAK_THREAD_DAEMON = new BitSet();
        Runtime.queueHook(2, new AbstractRunnable(true){

            @Override
            public void doRun() {
                String pto;
                ThreadUsageSampler.stop();
                switch (pto = System.getProperty("spf4j.threadUsageSampler.peakThreadsOnShutdown", "out")) {
                    case "out": 
                    case "info": {
                        ThreadUsageSampler.logPeakThreadInfo(Level.INFO);
                        break;
                    }
                    case "err": 
                    case "warn": {
                        ThreadUsageSampler.logPeakThreadInfo(Level.WARNING);
                        break;
                    }
                    case "none": {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid settig for spf4j.threadUsageSampler.peakThreadsOnShutdown: " + pto);
                    }
                }
            }
        });
        Registry.export(ThreadUsageSampler.class);
    }

    private static final class ThreadStateRecorder
    extends AbstractRunnable {
        private final MeasurementRecorder cpuUsage;
        private final boolean withStackTraces;
        private int maxThreadsNr = 0;

        ThreadStateRecorder(int sampleTime, boolean withStackTraces) {
            this.cpuUsage = RecorderFactory.createDirectRecorder((Object)"peak_thread_count", "count", sampleTime);
            this.withStackTraces = withStackTraces;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void doRun() {
            int peakThreadCount = TH_BEAN.getPeakThreadCount();
            this.cpuUsage.record(peakThreadCount);
            if (TH_BEAN.getThreadCount() > this.maxThreadsNr) {
                Class<ThreadUsageSampler> clazz = ThreadUsageSampler.class;
                // MONITORENTER : org.spf4j.perf.cpu.ThreadUsageSampler.class
                Thread[] ths = Threads.getThreads();
                peakTime = Instant.now();
                if (ths.length > PEAK_THREAD_NAMES.size()) {
                    if (this.withStackTraces) {
                        StackTraceElement[][] stackTraces = Threads.getStackTraces(ths);
                        PEAK_THREAD_TRACES.clear();
                        PEAK_THREAD_TRACES.addAll(Arrays.asList(stackTraces));
                    }
                    PEAK_THREAD_NAMES.clear();
                    int i = 0;
                    Thread[] threadArray = ths;
                    int n = threadArray.length;
                    for (int j = 0; j < n; ++i, ++j) {
                        Thread th = threadArray[j];
                        PEAK_THREAD_NAMES.add(th.getName());
                        if (th.isDaemon()) {
                            PEAK_THREAD_DAEMON.set(i);
                            continue;
                        }
                        PEAK_THREAD_DAEMON.clear(i);
                    }
                }
                this.maxThreadsNr = peakThreadCount;
                // MONITOREXIT : clazz
            }
            TH_BEAN.resetPeakThreadCount();
        }
    }
}

