/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.tsdb2.avro.Aggregation;
import org.spf4j.tsdb2.avro.MeasurementType;

@Immutable
public final class MeasurementsInfoImpl
implements MeasurementsInfo {
    private final Object measuredEntity;
    private final String description;
    private final String[] measurementNames;
    private final String[] measurementUnits;
    private final Aggregation[] aggregations;
    private final MeasurementType measurementType;

    public MeasurementsInfoImpl(Object measuredEntity, String description, String[] measurementNames, String[] measurementUnits, MeasurementType measurementType) {
        this(measuredEntity, description, measurementNames, measurementUnits, MeasurementsInfoImpl.defaultAggs(measurementNames.length), measurementType);
    }

    private static Aggregation[] defaultAggs(int nr) {
        Object[] result = new Aggregation[nr];
        Arrays.fill(result, Aggregation.UNKNOWN);
        return result;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public MeasurementsInfoImpl(Object measuredEntity, String description, String[] measurementNames, String[] measurementUnits, Aggregation[] aggregations, MeasurementType measurementType) {
        this.measuredEntity = measuredEntity;
        this.description = description;
        this.measurementNames = measurementNames;
        this.measurementUnits = measurementUnits;
        this.aggregations = aggregations;
        this.measurementType = measurementType;
    }

    @Override
    public MeasurementType getMeasurementType() {
        return this.measurementType;
    }

    @Override
    public Object getMeasuredEntity() {
        return this.measuredEntity;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String[] getMeasurementNames() {
        return (String[])this.measurementNames.clone();
    }

    public int hashCode() {
        return this.measuredEntity.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MeasurementsInfoImpl other = (MeasurementsInfoImpl)obj;
        if (!(this.measuredEntity == other.measuredEntity || this.measuredEntity != null && this.measuredEntity.equals(other.measuredEntity))) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return Arrays.equals(this.measurementNames, other.measurementNames);
    }

    public String toString() {
        return "EntityMeasurementsInfoImpl{measuredEntity=" + this.measuredEntity + ", description=" + this.description + ", measurementNames=" + Arrays.toString(this.measurementNames) + ", measurementUnits=" + Arrays.toString(this.measurementUnits) + '}';
    }

    @Override
    public int getNumberOfMeasurements() {
        return this.measurementNames.length;
    }

    @Override
    public String[] getMeasurementUnits() {
        return (String[])this.measurementUnits.clone();
    }

    @Override
    public String getMeasurementName(int measurementNr) {
        return this.measurementNames[measurementNr];
    }

    @Override
    public String getMeasurementUnit(int measurementNr) {
        return this.measurementUnits[measurementNr];
    }

    @Override
    public Aggregation[] getAggregations() {
        return (Aggregation[])this.aggregations.clone();
    }

    @Override
    public Aggregation getMeasurementAggregation(int measurementNr) {
        return this.aggregations[measurementNr];
    }
}

