/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.CharSequences;
import org.spf4j.io.Csv;
import org.spf4j.io.csv.CsvParseException;
import org.spf4j.perf.CloseableMeasurementRecorder;
import org.spf4j.perf.CloseableMeasurementRecorderSource;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.MeasurementRecorderSource;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MultiMeasurementRecorder;
import org.spf4j.perf.impl.DirectRecorderSource;
import org.spf4j.perf.impl.MeasurementsInfoImpl;
import org.spf4j.perf.impl.NopMeasurementStore;
import org.spf4j.perf.impl.ScalableMeasurementRecorder;
import org.spf4j.perf.impl.ScalableMeasurementRecorderSource;
import org.spf4j.perf.impl.acc.AddAndCountAccumulator;
import org.spf4j.perf.impl.acc.DirectStoreAccumulator;
import org.spf4j.perf.impl.acc.DirectStoreMultiAccumulator;
import org.spf4j.perf.impl.acc.MinMaxAvgAccumulator;
import org.spf4j.perf.impl.acc.QuantizedAccumulator;
import org.spf4j.perf.impl.ms.Flusher;
import org.spf4j.perf.impl.ms.MultiStore;
import org.spf4j.perf.impl.ms.StoreType;
import org.spf4j.perf.impl.ms.graphite.GraphiteTcpStore;
import org.spf4j.perf.impl.ms.graphite.GraphiteUdpStore;
import org.spf4j.perf.impl.ms.tsdb.AvroMeasurementStore;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.tsdb2.avro.Aggregation;
import org.spf4j.tsdb2.avro.MeasurementType;

public final class RecorderFactory {
    private static final Logger LOG;
    public static final MeasurementStore MEASUREMENT_STORE;

    private RecorderFactory() {
    }

    public static MeasurementStore getMeasurementStore() {
        return MEASUREMENT_STORE;
    }

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    private static MeasurementStore buildStoreFromConfig(@Nullable String configuration) throws IOException, ObjectCreationException {
        List<String> stores;
        if (configuration == null || configuration.trim().isEmpty()) {
            return new AvroMeasurementStore(Paths.get(System.getProperty("spf4j.perf.ms.defaultTsdbFolderPath", System.getProperty("java.io.tmpdir")), new String[0]), CharSequences.validatedFileName(System.getProperty("spf4j.perf.ms.defaultTsdbFileNamePrefix", ManagementFactory.getRuntimeMXBean().getName())));
        }
        try {
            stores = Csv.readRow(new StringReader(configuration));
        }
        catch (CsvParseException ex) {
            throw new IllegalArgumentException("Invalid configuration " + configuration, ex);
        }
        int size = stores.size();
        if (size == 1) {
            return StoreType.fromString(stores.get(0));
        }
        MeasurementStore[] mstores = new MeasurementStore[size];
        int i = 0;
        for (String config : stores) {
            mstores[i] = StoreType.fromString(config);
            ++i;
        }
        return new MultiStore(mstores);
    }

    public static MeasurementRecorder createScalableQuantizedRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis, int factor, int lowerMagnitude, int higherMagnitude, int quantasPerMagnitude) {
        ScalableMeasurementRecorder mr = new ScalableMeasurementRecorder(new QuantizedAccumulator(forWhat, "", unitOfMeasurement, factor, lowerMagnitude, higherMagnitude, quantasPerMagnitude), sampleTimeMillis, MEASUREMENT_STORE, true);
        mr.registerJmx();
        return mr;
    }

    public static CloseableMeasurementRecorder createScalableQuantizedRecorder2(Object forWhat, String unitOfMeasurement, int sampleTimeMillis, int factor, int lowerMagnitude, int higherMagnitude, int quantasPerMagnitude) {
        ScalableMeasurementRecorder mr = new ScalableMeasurementRecorder(new QuantizedAccumulator(forWhat, "", unitOfMeasurement, factor, lowerMagnitude, higherMagnitude, quantasPerMagnitude), sampleTimeMillis, MEASUREMENT_STORE, false);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createScalableCountingRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorder mr = new ScalableMeasurementRecorder(new AddAndCountAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE, true);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createScalableMinMaxAvgRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorder mr = new ScalableMeasurementRecorder(new MinMaxAvgAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE, true);
        mr.registerJmx();
        return mr;
    }

    public static CloseableMeasurementRecorder createScalableMinMaxAvgRecorder2(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorder mr = new ScalableMeasurementRecorder(new MinMaxAvgAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE, false);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorderSource createScalableQuantizedRecorderSource(Object forWhat, String unitOfMeasurement, int sampleTimeMillis, int factor, int lowerMagnitude, int higherMagnitude, int quantasPerMagnitude) {
        ScalableMeasurementRecorderSource mrs = new ScalableMeasurementRecorderSource(new QuantizedAccumulator(forWhat, "", unitOfMeasurement, factor, lowerMagnitude, higherMagnitude, quantasPerMagnitude), sampleTimeMillis, MEASUREMENT_STORE, true);
        mrs.registerJmx();
        return mrs;
    }

    public static CloseableMeasurementRecorderSource createScalableQuantizedRecorderSource2(Object forWhat, String unitOfMeasurement, int sampleTimeMillis, int factor, int lowerMagnitude, int higherMagnitude, int quantasPerMagnitude) {
        ScalableMeasurementRecorderSource mrs = new ScalableMeasurementRecorderSource(new QuantizedAccumulator(forWhat, "", unitOfMeasurement, factor, lowerMagnitude, higherMagnitude, quantasPerMagnitude), sampleTimeMillis, MEASUREMENT_STORE, false);
        mrs.registerJmx();
        return mrs;
    }

    public static MeasurementRecorderSource createScalableCountingRecorderSource(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorderSource mrs = new ScalableMeasurementRecorderSource(new AddAndCountAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE, true);
        mrs.registerJmx();
        return mrs;
    }

    public static CloseableMeasurementRecorderSource createScalableCountingRecorderSource2(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorderSource mrs = new ScalableMeasurementRecorderSource(new AddAndCountAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE, false);
        mrs.registerJmx();
        return mrs;
    }

    public static MeasurementRecorderSource createScalableMinMaxAvgRecorderSource(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorderSource mrs = new ScalableMeasurementRecorderSource(new MinMaxAvgAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE, true);
        mrs.registerJmx();
        return mrs;
    }

    public static MultiMeasurementRecorder createDirectRecorder(Object measuredEntity, String description, String[] measurementNames, String[] measurementUnits) {
        Object[] aggs = new Aggregation[measurementNames.length];
        Arrays.fill(aggs, Aggregation.UNKNOWN);
        DirectStoreMultiAccumulator mr = new DirectStoreMultiAccumulator(new MeasurementsInfoImpl(measuredEntity, description, measurementNames, measurementUnits, (Aggregation[])aggs, MeasurementType.UNTYPED), MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MultiMeasurementRecorder createDirectRecorder(Object measuredEntity, String description, String[] measurementNames, String[] measurementUnits, MeasurementType type) {
        Object[] aggs = new Aggregation[measurementNames.length];
        Arrays.fill(aggs, Aggregation.UNKNOWN);
        DirectStoreMultiAccumulator mr = new DirectStoreMultiAccumulator(new MeasurementsInfoImpl(measuredEntity, description, measurementNames, measurementUnits, (Aggregation[])aggs, type), MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createDirectRecorder(Object forWhat, String unitOfMeasurement) {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, 0, MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createDirectRecorder(Object forWhat, String unitOfMeasurement, MeasurementType type) {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, 0, MEASUREMENT_STORE, type);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createDirectRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, sampleTimeMillis, MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createDirectRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis, MeasurementType type) {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, sampleTimeMillis, MEASUREMENT_STORE, type);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorderSource createDirectRecorderSource(Object forWhat, String unitOfMeasurement) {
        return new DirectRecorderSource(forWhat, "", unitOfMeasurement, 0, MEASUREMENT_STORE);
    }

    public static MeasurementRecorder createDirectGraphiteUdpRecorder(Object forWhat, String unitOfMeasurement, String graphiteHost, int graphitePort) throws ObjectCreationException {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, 0, new GraphiteUdpStore(graphiteHost, graphitePort));
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createDirectGraphiteTcpRecorder(Object forWhat, String unitOfMeasurement, String graphiteHost, int graphitePort) throws ObjectCreationException {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, 0, new GraphiteTcpStore(graphiteHost, graphitePort));
        mr.registerJmx();
        return mr;
    }

    static {
        MeasurementStore mStore;
        LOG = LoggerFactory.getLogger(RecorderFactory.class);
        try {
            mStore = RecorderFactory.buildStoreFromConfig(System.getProperty("spf4j.perf.ms.config", null));
        }
        catch (IOException | ObjectCreationException ex) {
            LOG.error("Cannot initialize measurement store, installing NOP store", (Throwable)ex);
            mStore = new NopMeasurementStore();
        }
        if (!(mStore instanceof NopMeasurementStore) && Boolean.getBoolean("spf4j.perf.ms.periodicFlush")) {
            Flusher.flushEvery(Integer.getInteger("spf4j.perf.ms.flushIntervalMillis", 60000), mStore);
        }
        MEASUREMENT_STORE = mStore;
    }
}

