/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.acc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import org.spf4j.perf.MeasurementAccumulator;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.impl.MeasurementsInfoImpl;
import org.spf4j.perf.impl.acc.AbstractMeasurementAccumulator;
import org.spf4j.tsdb2.avro.Aggregation;
import org.spf4j.tsdb2.avro.MeasurementType;

public final class AddAndCountAccumulator
extends AbstractMeasurementAccumulator {
    private static final String[] MEASUREMENTS = new String[]{"count", "total"};
    private static final Aggregation[] AGGS = new Aggregation[]{Aggregation.SUM, Aggregation.SUM};
    private long counter;
    private long total;
    private final MeasurementsInfo info;

    private AddAndCountAccumulator(Object measuredEntity, String description, String unitOfMeasurement, long counter, long total) {
        this.info = new MeasurementsInfoImpl(measuredEntity, description, MEASUREMENTS, new String[]{"count", unitOfMeasurement}, AGGS, MeasurementType.SUMMARY);
        this.counter = counter;
        this.total = total;
    }

    public AddAndCountAccumulator(Object measuredEntity, String description, String unitOfMeasurement) {
        this(measuredEntity, description, unitOfMeasurement, 0L, 0L);
    }

    public String getUnitOfMeasurement() {
        return this.info.getMeasurementUnit(1);
    }

    @Override
    public synchronized void record(long measurement) {
        this.total += measurement;
        ++this.counter;
    }

    @Override
    @Nullable
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public synchronized long[] get() {
        if (this.counter == 0L) {
            return null;
        }
        return new long[]{this.counter, this.total};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX", "NOS_NON_OWNED_SYNCHRONIZATION"})
    public MeasurementAccumulator aggregate(MeasurementAccumulator mSource) {
        if (mSource instanceof AddAndCountAccumulator) {
            AddAndCountAccumulator other = (AddAndCountAccumulator)mSource;
            long[] measurements = other.get();
            if (measurements != null) {
                AddAndCountAccumulator addAndCountAccumulator = this;
                synchronized (addAndCountAccumulator) {
                    return new AddAndCountAccumulator(this.info.getMeasuredEntity(), this.info.getDescription(), this.getUnitOfMeasurement(), this.counter + measurements[0], this.total + measurements[1]);
                }
            }
            return this.createClone();
        }
        throw new IllegalArgumentException("Cannot aggregate " + this + " with " + mSource);
    }

    @Override
    public synchronized AddAndCountAccumulator createClone() {
        return new AddAndCountAccumulator(this.info.getMeasuredEntity(), this.info.getDescription(), this.getUnitOfMeasurement(), this.counter, this.total);
    }

    @Override
    public AddAndCountAccumulator createLike(Object entity) {
        return new AddAndCountAccumulator(entity, this.info.getDescription(), this.getUnitOfMeasurement());
    }

    @Override
    public MeasurementsInfo getInfo() {
        return this.info;
    }

    @Override
    @Nullable
    public synchronized MeasurementAccumulator reset() {
        if (this.counter == 0L) {
            return null;
        }
        AddAndCountAccumulator result = this.createClone();
        this.counter = 0L;
        this.total = 0L;
        return result;
    }

    @Override
    @Nullable
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public long[] getThenReset() {
        MeasurementAccumulator vals = this.reset();
        if (vals == null) {
            return null;
        }
        return vals.get();
    }

    public String toString() {
        return "CountingAccumulator{counter=" + this.counter + ", total=" + this.total + ", info=" + this.info + '}';
    }
}

