/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.spf4j.base.Throwables;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MeasurementStoreQuery;
import org.spf4j.perf.MeasurementsInfo;

public final class MultiStore
implements MeasurementStore {
    private final MeasurementStore[] stores;
    private final TLongObjectMap<long[]> idToIds;
    private final TObjectLongMap<MeasurementsInfo> infoToId;
    private long idSeq;

    public MultiStore(MeasurementStore ... stores) {
        if (stores.length <= 1) {
            throw new IllegalArgumentException("You need to supply more than 1 store, not " + Arrays.toString(stores));
        }
        this.stores = stores;
        this.idToIds = new TLongObjectHashMap();
        this.infoToId = new TObjectLongHashMap();
        this.idSeq = 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long alocateMeasurements(MeasurementsInfo measurement, int sampleTimeMillis) throws IOException {
        IOException ex = null;
        TLongObjectMap<long[]> tLongObjectMap = this.idToIds;
        synchronized (tLongObjectMap) {
            long id = this.infoToId.get((Object)measurement);
            if (id <= 0L) {
                long[] ids = new long[this.stores.length];
                int i = 0;
                for (MeasurementStore store : this.stores) {
                    try {
                        ids[i++] = store.alocateMeasurements(measurement, sampleTimeMillis);
                    }
                    catch (IOException e) {
                        if (ex != null) {
                            Throwables.suppressLimited(e, ex);
                        }
                        ex = e;
                    }
                }
                if (ex != null) {
                    throw ex;
                }
                id = this.idSeq++;
                this.infoToId.put((Object)measurement, id);
                this.idToIds.put(id, (Object)ids);
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveMeasurements(long tableId, long timeStampMillis, long ... measurements) throws IOException {
        long[] ids;
        IOException ex = null;
        TLongObjectMap<long[]> tLongObjectMap = this.idToIds;
        synchronized (tLongObjectMap) {
            ids = (long[])this.idToIds.get(tableId);
        }
        if (ids == null) {
            throw new IOException("Table id is invalid " + tableId);
        }
        int i = 0;
        for (MeasurementStore store : this.stores) {
            try {
                store.saveMeasurements(ids[i++], timeStampMillis, measurements);
            }
            catch (IOException e) {
                if (ex != null) {
                    Throwables.suppressLimited(e, ex);
                }
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public void flush() throws IOException {
        IOException ex = null;
        for (MeasurementStore store : this.stores) {
            try {
                store.flush();
            }
            catch (IOException e) {
                if (ex != null) {
                    Throwables.suppressLimited(e, ex);
                }
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        IOException ex = null;
        for (MeasurementStore store : this.stores) {
            try {
                store.close();
            }
            catch (IOException e) {
                if (ex != null) {
                    Throwables.suppressLimited(e, ex);
                }
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public List<MeasurementStore> getStores() {
        return Arrays.asList(this.stores);
    }

    public String toString() {
        return "MultiStore{stores=" + Arrays.toString(this.stores) + '}';
    }

    @Override
    public MeasurementStoreQuery query() {
        for (MeasurementStore store : this.stores) {
            MeasurementStoreQuery query = store.query();
            if (query == null) continue;
            return query;
        }
        return null;
    }
}

