/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.spf4j.jmx.Registry;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.impl.NopMeasurementStore;
import org.spf4j.perf.impl.ms.StoreFactory;
import org.spf4j.perf.impl.ms.graphite.GraphiteTcpStore;
import org.spf4j.perf.impl.ms.graphite.GraphiteUdpStore;
import org.spf4j.perf.impl.ms.tsdb.AvroMeasurementStore;
import org.spf4j.perf.impl.ms.tsdb.TSDBMeasurementStore;
import org.spf4j.perf.impl.ms.tsdb.TSDBTxtMeasurementStore;
import org.spf4j.recyclable.ObjectCreationException;

public enum StoreType {
    TSDB(new StoreFactory(){

        @Override
        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
        public MeasurementStore create(String pconfig) throws IOException {
            String config = !pconfig.endsWith("tsdb2") ? pconfig + ".tsdb2" : pconfig;
            return new TSDBMeasurementStore(new File(config));
        }
    }),
    TSDB_AVRO(new StoreFactory(){

        @Override
        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
        public MeasurementStore create(String pconfig) throws IOException {
            Path path = Paths.get(pconfig, new String[0]);
            Path parent = path.getParent();
            if (parent == null) {
                throw new IllegalArgumentException("Invalid store config " + pconfig);
            }
            Path fileName = path.getFileName();
            if (fileName == null) {
                throw new IllegalArgumentException("Invalid store config " + pconfig);
            }
            return new AvroMeasurementStore(parent, fileName.toString());
        }
    }),
    TSDB_TXT(new StoreFactory(){

        @Override
        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
        public MeasurementStore create(String config) throws IOException {
            return new TSDBTxtMeasurementStore(new File(config));
        }
    }),
    GRAPHITE_UDP(new StoreFactory(){

        @Override
        public MeasurementStore create(String config) throws ObjectCreationException {
            try {
                return new GraphiteUdpStore(config);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Invalid configuration " + config, ex);
            }
        }
    }),
    GRAPHITE_TCP(new StoreFactory(){

        @Override
        public MeasurementStore create(String config) throws ObjectCreationException {
            try {
                return new GraphiteTcpStore(config);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException("Invalid configuration " + config, ex);
            }
        }
    }),
    NOP_STORE(new StoreFactory(){

        @Override
        public MeasurementStore create(String config) {
            return new NopMeasurementStore();
        }
    }),
    CUSTOM(new StoreFactory(){

        @Override
        public MeasurementStore create(String config) {
            try {
                return (MeasurementStore)Class.forName(config).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }),
    WRAPPER(new StoreFactory(){

        @Override
        public MeasurementStore create(String config) throws IOException, ObjectCreationException {
            int fp = config.indexOf(40);
            int lp = config.lastIndexOf(41);
            if (fp < 0 || lp < 0 || lp < fp) {
                throw new IllegalArgumentException("Invalid wrapper config: " + config);
            }
            String className = config.substring(0, fp);
            MeasurementStore ms = StoreType.fromString(config.substring(fp + 1, lp));
            try {
                return (MeasurementStore)Class.forName(className).getConstructor(MeasurementStore.class).newInstance(ms);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    });

    private final StoreFactory factory;

    private StoreType(StoreFactory factory) {
        this.factory = factory;
    }

    private MeasurementStore create(String configuration) throws IOException, ObjectCreationException {
        MeasurementStore store = this.factory.create(configuration);
        Registry.exportIfNeeded(store.getClass().getName(), store.toString(), store);
        return store;
    }

    public static MeasurementStore fromString(String string) throws IOException, ObjectCreationException {
        int atIdx = string.indexOf(64);
        int length = string.length();
        if (atIdx < 0) {
            atIdx = length;
        }
        StoreType type = StoreType.valueOf(string.substring(0, atIdx));
        if (atIdx >= length) {
            return type.create("");
        }
        return type.create(string.substring(atIdx + 1));
    }
}

