/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms.tsdb;

import com.google.common.primitives.Longs;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.spf4j.jmx.JmxExport;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MeasurementStoreQuery;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.impl.ms.tsdb.AvroFileInfo;
import org.spf4j.perf.impl.ms.tsdb.AvroMeasurementStoreReader;
import org.spf4j.tsdb2.TableDefs;
import org.spf4j.tsdb2.avro.Observation;
import org.spf4j.tsdb2.avro.TableDef;

@ThreadSafe
public final class AvroMeasurementStore
implements MeasurementStore {
    private CodecFactory codecFact;
    private DataFileWriter<TableDef> infoWriter;
    private DataFileWriter<Observation> dataWriter;
    private Path infoFile;
    private Path dataFile;
    private long ids;
    private final long timeRef;
    private final AvroMeasurementStoreReader reader;

    public AvroMeasurementStore(Path destinationPath, String fileNameBase) throws IOException {
        this(destinationPath, fileNameBase, Boolean.parseBoolean(System.getProperty("spf4j.perf.avro.snappyEnable", "true")));
    }

    public AvroMeasurementStore(Path destinationPath, String fileNameBase, boolean snappyCompress) throws IOException {
        if (snappyCompress) {
            try {
                Class.forName("org.xerial.snappy.Snappy");
                this.codecFact = CodecFactory.snappyCodec();
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(AvroMeasurementStore.class.getName()).info("Snappy compression not available for metrics store");
                this.codecFact = null;
            }
        } else {
            this.codecFact = null;
        }
        AvroFileInfo<TableDef> info = this.initWriter(fileNameBase, destinationPath, true, TableDef.class);
        this.infoFile = info.getFilePath();
        this.infoWriter = info.getFileWriter();
        AvroFileInfo<Observation> data = this.initWriter(fileNameBase, destinationPath, false, Observation.class);
        this.dataFile = data.getFilePath();
        this.dataWriter = data.getFileWriter();
        this.timeRef = data.getFileEpoch();
        this.reader = new AvroMeasurementStoreReader(this.infoFile, this.dataFile);
    }

    private <T extends SpecificRecord> AvroFileInfo<T> initWriter(String fileNameBase, Path destinationPath, boolean countEntries, Class<T> clasz) throws IOException {
        long initNrRecords;
        DataFileWriter writer = new DataFileWriter((DatumWriter)new SpecificDatumWriter(clasz));
        if (this.codecFact != null) {
            writer.setCodec(this.codecFact);
        }
        long epoch = System.currentTimeMillis();
        writer.setMeta("timeRef", epoch);
        String fileName = fileNameBase + '.' + clasz.getSimpleName().toLowerCase(Locale.US) + ".avro";
        Path file = destinationPath.resolve(fileName);
        if (Files.isWritable(file)) {
            try (DataFileStream streamReader = new DataFileStream(Files.newInputStream(file, new OpenOption[0]), (DatumReader)new SpecificDatumReader(clasz));){
                if (countEntries) {
                    long count = 0L;
                    while (streamReader.hasNext()) {
                        count += streamReader.getBlockCount();
                        streamReader.nextBlock();
                    }
                    initNrRecords = count;
                } else {
                    initNrRecords = -1L;
                }
                epoch = streamReader.getMetaLong("timeRef");
            }
            writer = writer.appendTo(file.toFile());
        } else {
            try {
                writer.create(((SpecificRecord)clasz.newInstance()).getSchema(), file.toFile());
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            initNrRecords = 0L;
        }
        return new AvroFileInfo(file, writer, epoch, initNrRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long alocateMeasurements(MeasurementsInfo measurement, int sampleTimeMillis) throws IOException {
        DataFileWriter<TableDef> dataFileWriter = this.infoWriter;
        synchronized (dataFileWriter) {
            long id = this.ids++;
            this.infoWriter.append((Object)TableDefs.from(measurement, sampleTimeMillis, id));
            return id;
        }
    }

    public static <T extends SpecificRecord> long getNrRecords(Path avroFile, Class<T> clasz) throws IOException {
        try (DataFileStream streamReader = new DataFileStream(Files.newInputStream(avroFile, new OpenOption[0]), (DatumReader)new SpecificDatumReader(clasz));){
            long count = 0L;
            while (streamReader.hasNext()) {
                count += streamReader.getBlockCount();
                streamReader.nextBlock();
            }
            long l = count;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveMeasurements(long tableId, long timeStampMillis, long ... measurements) throws IOException {
        DataFileWriter<Observation> dataFileWriter = this.dataWriter;
        synchronized (dataFileWriter) {
            this.dataWriter.append((Object)new Observation(timeStampMillis - this.timeRef, tableId, Longs.asList((long[])measurements)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        DataFileWriter<TableDef> dataFileWriter = this.infoWriter;
        synchronized (dataFileWriter) {
            this.infoWriter.close();
        }
        dataFileWriter = this.dataWriter;
        synchronized (dataFileWriter) {
            this.dataWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JmxExport(description="flush out buffers")
    public void flush() throws IOException {
        DataFileWriter<TableDef> dataFileWriter = this.infoWriter;
        synchronized (dataFileWriter) {
            this.infoWriter.flush();
        }
        dataFileWriter = this.dataWriter;
        synchronized (dataFileWriter) {
            this.dataWriter.flush();
        }
    }

    public Path getInfoFile() {
        return this.infoFile;
    }

    public Path getDataFile() {
        return this.dataFile;
    }

    public String toString() {
        return "AvroMeasurementStore{codecFact=" + this.codecFact + ", infoWriter=" + this.infoWriter + ", dataWriter=" + this.dataWriter + ", infoFile=" + this.infoFile + ", dataFile=" + this.dataFile + ", ids=" + this.ids + ", timeRef=" + this.timeRef + '}';
    }

    @Override
    public MeasurementStoreQuery query() {
        return this.reader;
    }
}

