/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms.tsdb;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.hash.THashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.spf4j.base.Closeables;
import org.spf4j.base.Pair;
import org.spf4j.base.avro.AvroCloseableIterable;
import org.spf4j.perf.MeasurementStoreQuery;
import org.spf4j.tsdb2.TableDefs;
import org.spf4j.tsdb2.avro.Observation;
import org.spf4j.tsdb2.avro.TableDef;

@ParametersAreNonnullByDefault
public final class AvroMeasurementStoreReader
implements MeasurementStoreQuery {
    private final Path infoFile;
    private final Path[] dataFiles;

    public AvroMeasurementStoreReader(Path infoFile) throws IOException {
        this(infoFile, AvroMeasurementStoreReader.lookupObservationFiles(infoFile).toArray(new Path[1]));
    }

    public AvroMeasurementStoreReader(Path infoFile, Path ... dataFiles) {
        this.infoFile = infoFile;
        this.dataFiles = dataFiles;
    }

    public static List<Path> lookupObservationFiles(Path infoFile) throws IOException {
        ArrayList<Path> dataFiles = new ArrayList<Path>(4);
        Path fn = infoFile.getFileName();
        if (fn == null) {
            throw new IllegalArgumentException("Invalid info file " + infoFile);
        }
        String fileName = fn.toString();
        final String prefix = fileName.substring(0, fileName.length() - ".tabledef.avro".length());
        Path parent = infoFile.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Invalid info file " + infoFile);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(parent, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    return false;
                }
                Path fnp = entry.getFileName();
                if (fnp == null) {
                    return false;
                }
                String fName = fnp.toString();
                return fName.startsWith(prefix) && fName.endsWith(".observation.avro");
            }
        });){
            for (Path f : stream) {
                dataFiles.add(f);
            }
        }
        return dataFiles;
    }

    @Override
    public Collection<Schema> getMeasurements(Predicate<String> filter) throws IOException {
        THashMap result = new THashMap();
        try (DataFileStream stream = new DataFileStream(Files.newInputStream(this.infoFile, new OpenOption[0]), (DatumReader)new SpecificDatumReader(TableDef.class));){
            for (TableDef td : stream) {
                String name = td.getName();
                if (!filter.test(name)) continue;
                Pair exSch = (Pair)result.get(name);
                if (exSch == null) {
                    Schema sch = TableDefs.createSchema(td);
                    HashSet<Long> ids = new HashSet<Long>(2);
                    ids.add(td.getId());
                    exSch = Pair.of(sch, ids);
                    result.put(name, exSch);
                    continue;
                }
                ((Set)exSch.getValue()).add(td.getId());
            }
        }
        return result.values().stream().map(x -> {
            Schema sch = (Schema)x.getKey();
            sch.addProp("ids", x.getValue());
            return sch;
        }).collect(Collectors.toCollection(() -> AvroMeasurementStoreReader.lambda$getMeasurements$1((Map)result)));
    }

    @Override
    public AvroCloseableIterable<Observation> getObservations() throws IOException {
        Schema oSchema = Observation.getClassSchema();
        if (this.dataFiles.length == 0) {
            return AvroCloseableIterable.from(Collections.emptyList(), () -> {}, oSchema);
        }
        SpecificDatumReader specificDatumReader = new SpecificDatumReader(Observation.class);
        Iterable[] streams = new Iterable[this.dataFiles.length];
        Closeable[] closeables = new Closeable[this.dataFiles.length];
        for (int i = 0; i < this.dataFiles.length; ++i) {
            DataFileStream ds;
            Path dataFile = this.dataFiles[i];
            try {
                ds = new DataFileStream(Files.newInputStream(dataFile, new OpenOption[0]), (DatumReader)specificDatumReader);
            }
            catch (IOException ex) {
                IOException ex2 = Closeables.closeAll(closeables, 0, i);
                if (ex2 != null) {
                    ex2.addSuppressed(ex);
                    throw ex2;
                }
                throw ex;
            }
            long fileTimeRef = ds.getMetaLong("timeRef");
            streams[i] = Iterables.transform((Iterable)ds, (Function)new TimeCalibrate(fileTimeRef));
            closeables[i] = ds;
        }
        Iterable stream = Iterables.concat((Iterable[])streams);
        return AvroCloseableIterable.from(stream, () -> {
            IOException ex = Closeables.closeAll(closeables);
            if (ex != null) {
                throw new UncheckedIOException(ex);
            }
        }, oSchema);
    }

    public String toString() {
        return "AvroMeasurementStoreReader{infoFile=" + this.infoFile + ", dataFiles=" + Arrays.toString(this.dataFiles) + '}';
    }

    private static /* synthetic */ ArrayList lambda$getMeasurements$1(Map result) {
        return new ArrayList(result.size());
    }

    private static class TimeCalibrate
    implements Function<Observation, Observation> {
        private final long fileTimeRef;

        TimeCalibrate(long fileTimeRef) {
            this.fileTimeRef = fileTimeRef;
        }

        @SuppressFBWarnings(value={"CFS_CONFUSING_FUNCTION_SEMANTICS", "NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
        public Observation apply(@Nonnull Observation row) {
            row.setRelTimeStamp(this.fileTimeRef + row.getRelTimeStamp());
            return row;
        }
    }
}

