/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms.tsdb;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.jmx.JmxExport;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MeasurementStoreQuery;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.impl.ms.tsdb.TSDBMeasurementStoreReader;
import org.spf4j.tsdb2.TSDBQuery;
import org.spf4j.tsdb2.TSDBWriter;
import org.spf4j.tsdb2.TableDefs;

@ThreadSafe
public final class TSDBMeasurementStore
implements MeasurementStore {
    private final TSDBWriter database;
    private final TSDBMeasurementStoreReader reader;

    public TSDBMeasurementStore(File databaseFile) throws IOException {
        this.database = new TSDBWriter(databaseFile, 1024, "", false);
        this.reader = new TSDBMeasurementStoreReader(databaseFile);
    }

    @Override
    public long alocateMeasurements(MeasurementsInfo measurement, int sampleTimeMillis) throws IOException {
        return this.database.writeTableDef(TableDefs.from(measurement, sampleTimeMillis, -1L));
    }

    @Override
    public void saveMeasurements(long tableId, long timeStampMillis, long ... measurements) throws IOException {
        this.database.writeDataRow(tableId, timeStampMillis, measurements);
    }

    @Override
    public void close() throws IOException {
        this.database.close();
    }

    @Override
    @JmxExport(description="flush out buffers")
    public void flush() throws IOException {
        this.database.flush();
    }

    @JmxExport(description="list all tables")
    public String[] getTables() throws IOException {
        Set metrics = TSDBQuery.getAllTables(this.database.getFile()).keySet();
        return metrics.toArray(new String[metrics.size()]);
    }

    @JmxExport(description="getTable As Csv")
    public String getTableAsCsv(@JmxExport(value="tableName") String tableName) throws IOException {
        StringBuilder result = new StringBuilder(1024);
        TSDBQuery.writeAsCsv(result, this.database.getFile(), tableName);
        return result.toString();
    }

    public String toString() {
        return "TSDBMeasurementStore{database=" + this.database + '}';
    }

    public TSDBWriter getDBWriter() {
        return this.database;
    }

    @Override
    public MeasurementStoreQuery query() {
        return this.reader;
    }
}

