/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms.tsdb;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.spf4j.base.Pair;
import org.spf4j.base.avro.AvroCloseableIterable;
import org.spf4j.perf.MeasurementStoreQuery;
import org.spf4j.perf.TimeSeriesRecord;
import org.spf4j.tsdb2.TSDBQuery;
import org.spf4j.tsdb2.TableDefs;
import org.spf4j.tsdb2.avro.Observation;
import org.spf4j.tsdb2.avro.TableDef;

public final class TSDBMeasurementStoreReader
implements MeasurementStoreQuery {
    private final File dbFile;

    public TSDBMeasurementStoreReader(File dbFile) {
        this.dbFile = dbFile;
    }

    @Override
    public Collection<Schema> getMeasurements(Predicate<String> filter) throws IOException {
        ListMultimap<String, TableDef> allTables = TSDBQuery.getAllTables(this.dbFile);
        HashMap schemas = Maps.newHashMapWithExpectedSize((int)allTables.size());
        for (Map.Entry entry : allTables.entries()) {
            String key = (String)entry.getKey();
            if (!filter.test(key)) continue;
            Pair exSch = (Pair)schemas.get(key);
            TableDef td = (TableDef)entry.getValue();
            if (exSch == null) {
                Schema sch = TableDefs.createSchema(td);
                HashSet<Long> ids = new HashSet<Long>(2);
                ids.add(td.getId());
                exSch = Pair.of(sch, ids);
                schemas.put(key, exSch);
                continue;
            }
            ((Set)exSch.getValue()).add(td.getId());
        }
        return schemas.values().stream().map(x -> {
            Schema sch = (Schema)x.getKey();
            sch.addProp("ids", x.getValue());
            return sch;
        }).collect(Collectors.toCollection(() -> new ArrayList(schemas.size())));
    }

    @Override
    @Nullable
    public AvroCloseableIterable<TimeSeriesRecord> getMeasurementData(Schema measurement, Instant from, Instant to) throws IOException {
        return TSDBQuery.getTimeSeriesData(this.dbFile, from.toEpochMilli(), to.toEpochMilli(), (Collection)measurement.getObjectProp("ids"), measurement);
    }

    public String toString() {
        return "TSDBMeasurementStoreReader{dbFile=" + this.dbFile + '}';
    }

    @Override
    public AvroCloseableIterable<Observation> getObservations() throws IOException {
        return TSDBQuery.getTimeSeriesData(this.dbFile);
    }
}

