/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.memory;

import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.impl.RecorderFactory;
import org.spf4j.tsdb2.avro.MeasurementType;

public final class GCUsageSampler {
    private static final List<GarbageCollectorMXBean> MBEANS = ManagementFactory.getGarbageCollectorMXBeans();
    private static ScheduledFuture<?> samplingFuture;

    private GCUsageSampler() {
    }

    public static List<GarbageCollectorMXBean> getMBEANS() {
        return MBEANS;
    }

    @JmxExport
    public static synchronized void start(@JmxExport(value="sampleTimeMillis") int sampleTime) {
        if (samplingFuture != null) {
            throw new IllegalStateException("GC usage sampling already started " + samplingFuture);
        }
        final MeasurementRecorder gcUsage = RecorderFactory.createDirectRecorder((Object)"gc_time", "ms", sampleTime, MeasurementType.COUNTER);
        samplingFuture = DefaultScheduler.INSTANCE.scheduleWithFixedDelay(new AbstractRunnable(){
            private final TObjectLongMap lastValues = new TObjectLongHashMap();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doRun() {
                TObjectLongMap tObjectLongMap = this.lastValues;
                synchronized (tObjectLongMap) {
                    gcUsage.record(GCUsageSampler.getGCTimeDiff(MBEANS, this.lastValues));
                }
            }
        }, sampleTime, sampleTime, TimeUnit.MILLISECONDS);
    }

    @JmxExport
    public static synchronized void stop() {
        if (samplingFuture != null) {
            samplingFuture.cancel(false);
            samplingFuture = null;
        }
    }

    public static long getGCTimeDiff(Iterable<GarbageCollectorMXBean> gcBeans, TObjectLongMap lastValues) {
        long gcTime = 0L;
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            long currVal = gcBean.getCollectionTime();
            long prevVal = lastValues.put((Object)gcBean, currVal);
            gcTime += currVal - prevVal;
        }
        return gcTime;
    }

    public static long getGCTime(Iterable<GarbageCollectorMXBean> gcBeans) {
        long gcTime = 0L;
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            gcTime += gcBean.getCollectionTime();
        }
        return gcTime;
    }

    @JmxExport(description="Get the total GC time in millis since the JVM started")
    public static long getGCTime() {
        return GCUsageSampler.getGCTime(MBEANS);
    }

    @JmxExport
    public static synchronized boolean isStarted() {
        return samplingFuture != null;
    }

    static {
        Runtime.queueHook(2, new AbstractRunnable(true){

            @Override
            public void doRun() {
                GCUsageSampler.stop();
            }
        });
        Registry.export(GCUsageSampler.class);
    }
}

