/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.memory;

import com.sun.management.HotSpotDiagnosticMXBean;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.perf.CloseableMeasurementRecorder;
import org.spf4j.perf.impl.RecorderFactory;

@SuppressFBWarnings(value={"IICU_INCORRECT_INTERNAL_CLASS_USE"})
public final class MemoryUsageSampler {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final MemoryMXBean MBEAN = ManagementFactory.getMemoryMXBean();
    private static final HotSpotDiagnosticMXBean HOTSPOT_DIAGNOSTIC_INSTANCE = MemoryUsageSampler.getHotspotMBean();
    private static ScheduledFuture<?> samplingFuture;
    private static AccumulatorRunnable accumulatorRunnable;

    private static HotSpotDiagnosticMXBean getHotspotMBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            return ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
        }
        catch (IOException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private MemoryUsageSampler() {
    }

    public static synchronized void start(long sampleTimeMilis) {
        MemoryUsageSampler.start((int)sampleTimeMilis, (int)sampleTimeMilis * 10);
    }

    public static synchronized void start(int sampleTimeMilis) {
        MemoryUsageSampler.start(sampleTimeMilis, sampleTimeMilis * 10);
    }

    @JmxExport
    public static synchronized void start(@JmxExport(value="sampleTimeMillis") int sampleTimeMilis, @JmxExport(value="accumulateIntervalMillis") int accumulateIntervalMillis) {
        if (samplingFuture != null) {
            throw new IllegalStateException("Memory usage sampling already started " + samplingFuture);
        }
        accumulatorRunnable = new AccumulatorRunnable(accumulateIntervalMillis);
        samplingFuture = DefaultScheduler.INSTANCE.scheduleWithFixedDelay(accumulatorRunnable, sampleTimeMilis, sampleTimeMilis, TimeUnit.MILLISECONDS);
    }

    @JmxExport
    public static synchronized void stop() {
        if (samplingFuture != null) {
            samplingFuture.cancel(false);
            accumulatorRunnable.close();
            samplingFuture = null;
        }
    }

    @JmxExport
    public static synchronized boolean isStarted() {
        return samplingFuture != null;
    }

    public static void dumpHeap(String filename, boolean liveObjectOnly) throws IOException {
        HOTSPOT_DIAGNOSTIC_INSTANCE.dumpHeap(filename, liveObjectOnly);
    }

    public static HotSpotDiagnosticMXBean getHotspotDiagnosticBean() {
        return HOTSPOT_DIAGNOSTIC_INSTANCE;
    }

    static {
        Runtime.queueHook(2, new AbstractRunnable(true){

            @Override
            public void doRun() {
                MemoryUsageSampler.stop();
            }
        });
        Registry.export(MemoryUsageSampler.class);
    }

    private static class AccumulatorRunnable
    extends AbstractRunnable
    implements AutoCloseable {
        private final CloseableMeasurementRecorder heapCommited;
        private final CloseableMeasurementRecorder heapUsed;
        private final CloseableMeasurementRecorder nonHeapCommited;
        private final CloseableMeasurementRecorder nonHeapUsed;

        AccumulatorRunnable(int accumulationIntervalMillis) {
            this.heapCommited = RecorderFactory.createScalableMinMaxAvgRecorder2("heap_commited", "bytes", accumulationIntervalMillis);
            this.heapUsed = RecorderFactory.createScalableMinMaxAvgRecorder2("heap_used", "bytes", accumulationIntervalMillis);
            this.nonHeapCommited = RecorderFactory.createScalableMinMaxAvgRecorder2("non_heap_commited", "bytes", accumulationIntervalMillis);
            this.nonHeapUsed = RecorderFactory.createScalableMinMaxAvgRecorder2("non_heap_used", "bytes", accumulationIntervalMillis);
        }

        @Override
        public void doRun() throws Exception {
            MemoryUsage usage = MBEAN.getHeapMemoryUsage();
            this.heapCommited.record(usage.getCommitted());
            this.heapUsed.record(usage.getUsed());
            MemoryUsage nonHeapMemoryUsage = MBEAN.getNonHeapMemoryUsage();
            this.nonHeapCommited.record(nonHeapMemoryUsage.getCommitted());
            this.nonHeapUsed.record(nonHeapMemoryUsage.getUsed());
        }

        @Override
        public void close() {
            this.heapUsed.close();
            this.heapCommited.close();
            this.nonHeapCommited.close();
            this.nonHeapUsed.close();
        }
    }
}

