/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.pool.jdbc;

import com.google.common.annotations.Beta;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.spf4j.failsafe.RetryPolicy;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;

@Beta
public final class JdbcConnectionFactory
implements RecyclingSupplier.Factory<Connection> {
    private final String url;
    private final Properties props;
    private final int loginTimeoutSeconds;

    public JdbcConnectionFactory(String driverName, String url, String user, String password) {
        this(driverName, url, JdbcConnectionFactory.fromUserPassword(user, password), 15);
    }

    public JdbcConnectionFactory(String driverName, String url, String user, String password, int loginTimeoutSeconds) {
        this(driverName, url, JdbcConnectionFactory.fromUserPassword(user, password), loginTimeoutSeconds);
    }

    public JdbcConnectionFactory(String driverName, String url, Properties props, int loginTimeoutSeconds) {
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Invalid driver " + driverName, ex);
        }
        this.url = url;
        this.props = props;
        this.loginTimeoutSeconds = loginTimeoutSeconds;
    }

    private static Properties fromUserPassword(String user, String password) {
        Properties info = new Properties();
        info.setProperty("user", user);
        info.setProperty("password", password);
        return info;
    }

    @Override
    public Connection create() throws ObjectCreationException {
        DriverManager.setLoginTimeout(this.loginTimeoutSeconds);
        try {
            return (Connection)RetryPolicy.defaultPolicy().call(() -> DriverManager.getConnection(this.url, this.props), SQLException.class, (long)this.loginTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException | SQLException | TimeoutException ex) {
            throw new ObjectCreationException("Cannot connect to " + this.url + " in " + this.loginTimeoutSeconds + " s", ex);
        }
    }

    @Override
    public void dispose(Connection object) throws ObjectDisposeException {
        try {
            object.close();
        }
        catch (SQLException ex) {
            throw new ObjectDisposeException(ex);
        }
    }

    @Override
    public boolean validate(Connection object, Exception e) throws SQLException {
        return object.isValid(60);
    }

    public String toString() {
        return "JdbcConnectionFactory{url=" + this.url + '}';
    }
}

