/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.pool.jdbc;

import com.google.common.annotations.Beta;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.spf4j.jdbc.DataSourceEx;
import org.spf4j.pool.jdbc.JdbcConnectionFactory;
import org.spf4j.recyclable.ObjectBorrowException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.impl.RecyclingSupplierBuilder;

@Beta
public final class PooledDataSource
implements DataSourceEx,
AutoCloseable {
    private final RecyclingSupplier<Connection> pool;

    public PooledDataSource(int initialSize, int maxSize, String driverName, String url, String user, String password) throws ObjectCreationException {
        this(initialSize, maxSize, new JdbcConnectionFactory(driverName, url, user, password));
    }

    public PooledDataSource(int initialSize, int maxSize, String driverName, String url, Properties properties, int loginTimeoutSeconds) throws ObjectCreationException {
        this(initialSize, maxSize, new JdbcConnectionFactory(driverName, url, properties, loginTimeoutSeconds));
    }

    public PooledDataSource(int initialSize, int maxSize, RecyclingSupplier.Factory<Connection> jdbcConnectionFactory) throws ObjectCreationException {
        RecyclingSupplierBuilder<Connection> builder = new RecyclingSupplierBuilder<Connection>(maxSize, jdbcConnectionFactory);
        builder.withInitialSize(initialSize);
        this.pool = builder.build();
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection raw;
        try {
            raw = this.pool.get();
        }
        catch (InterruptedException | ObjectBorrowException | ObjectCreationException ex) {
            throw new SQLException(ex);
        }
        catch (TimeoutException ex) {
            throw new SQLTimeoutException(ex);
        }
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new PooledConnectionInvocationHandler(raw, this.pool));
    }

    @Override
    public Connection getConnection(long timeout, TimeUnit unit) throws SQLException {
        Connection raw;
        try {
            raw = this.pool.tryGet(timeout, unit);
            if (raw == null) {
                throw new SQLTimeoutException("Unable to obtain connection in " + timeout + " " + (Object)((Object)unit));
            }
        }
        catch (InterruptedException | ObjectBorrowException | ObjectCreationException ex) {
            throw new SQLException(ex);
        }
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new PooledConnectionInvocationHandler(raw, this.pool));
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getLoginTimeout() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.equals(DataSource.class) || iface.equals(PooledDataSource.class)) {
            return (T)this;
        }
        throw new SQLException("Not a wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.equals(DataSource.class) || iface.equals(PooledDataSource.class);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public String toString() {
        return "PooledDataSource{pool=" + this.pool + '}';
    }

    @Override
    public void close() throws ObjectDisposeException, InterruptedException {
        this.pool.dispose();
    }

    private static final class PooledConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection raw;
        private final RecyclingSupplier<Connection> pool;
        private Exception ex;
        private boolean closed = false;

        PooledConnectionInvocationHandler(Connection raw, RecyclingSupplier<Connection> pool) {
            this.raw = raw;
            this.pool = pool;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            String mName = method.getName();
            if ("close".equals(mName)) {
                if (!this.closed) {
                    this.pool.recycle(this.raw, this.ex);
                    this.ex = null;
                    this.closed = true;
                }
                return null;
            }
            if (this.closed) {
                throw new IllegalStateException("not aowner of this connection, it has been returned already to " + this.pool);
            }
            try {
                return method.invoke((Object)this.raw, args);
            }
            catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
                this.ex = e;
                throw e;
            }
        }
    }
}

