/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.recyclable.Disposable;
import org.spf4j.recyclable.ObjectDisposeException;

public interface BlockingDisposable
extends Disposable {
    @Override
    default public void dispose() throws ObjectDisposeException, InterruptedException {
        try {
            this.dispose(ExecutionContexts.getTimeToDeadline(TimeUnit.MILLISECONDS));
        }
        catch (TimeoutException ex) {
            throw new ObjectDisposeException(ex);
        }
    }

    default public void dispose(long timeoutMillis) throws ObjectDisposeException, InterruptedException, TimeoutException {
        if (!this.tryDispose(timeoutMillis)) {
            throw new TimeoutException("Unable to dispose  " + this + " within " + timeoutMillis + " miliseconds");
        }
    }

    @Override
    default public void close() throws ObjectDisposeException, InterruptedException {
        this.dispose();
    }

    public boolean tryDispose(long var1) throws ObjectDisposeException, InterruptedException;
}

