/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.TimeSource;
import org.spf4j.recyclable.BlockingDisposable;
import org.spf4j.recyclable.NonValidatingRecyclingSupplier;
import org.spf4j.recyclable.ObjectBorrowException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;

@ParametersAreNonnullByDefault
public interface RecyclingSupplier<T>
extends NonValidatingRecyclingSupplier<T>,
BlockingDisposable {
    @Override
    @Nonnull
    default public T get() throws ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException {
        return this.get(ExecutionContexts.getTimeToDeadline(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    @Nonnull
    default public T get(long timeout, TimeUnit unit) throws ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException {
        T tryGet = this.tryGet(timeout, unit);
        if (tryGet == null) {
            throw new TimeoutException("Timed out after " + timeout + " " + (Object)((Object)unit));
        }
        return tryGet;
    }

    @Nullable
    default public T tryGet(long timeout, TimeUnit unit) throws ObjectCreationException, ObjectBorrowException, InterruptedException {
        return this.tryGet(TimeSource.nanoTime() + unit.toNanos(timeout));
    }

    @Nullable
    public T tryGet(long var1) throws ObjectCreationException, ObjectBorrowException, InterruptedException;

    public void recycle(T var1, @Nullable Exception var2);

    @Override
    default public void recycle(T object) {
        this.recycle(object, null);
    }

    @ParametersAreNonnullByDefault
    public static interface Factory<T> {
        public T create() throws ObjectCreationException;

        public void dispose(T var1) throws ObjectDisposeException;

        @Nullable
        @CheckReturnValue
        public boolean validate(T var1, @Nullable Exception var2) throws Exception;
    }
}

