/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable;

import com.google.common.annotations.Beta;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.TimeSource;
import org.spf4j.recyclable.BlockingDisposable;
import org.spf4j.recyclable.ObjectBorower;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.Scanable;

@ParametersAreNonnullByDefault
@ThreadSafe
public interface SmartRecyclingSupplier<T>
extends BlockingDisposable,
Scanable<T> {
    @Nonnull
    default public T get(ObjectBorower borower) throws InterruptedException, TimeoutException, ObjectCreationException {
        return this.get(borower, ExecutionContexts.getTimeToDeadline(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    @Nonnull
    default public T get(ObjectBorower borower, long timeout, TimeUnit unit) throws ObjectCreationException, InterruptedException, TimeoutException {
        T tryGet = this.tryGet(borower, timeout, unit);
        if (tryGet == null) {
            throw new TimeoutException("Timed out after " + timeout + " " + (Object)((Object)unit));
        }
        return tryGet;
    }

    @Nullable
    default public T tryGet(ObjectBorower borower, long timeout, TimeUnit unit) throws ObjectCreationException, InterruptedException {
        return this.tryGet(borower, TimeSource.nanoTime() + unit.toNanos(timeout));
    }

    @Nullable
    public T tryGet(ObjectBorower var1, long var2) throws ObjectCreationException, InterruptedException;

    public void recycle(T var1, ObjectBorower var2);

    @Nonnull
    @Beta
    public T getSample();
}

