/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.HandlerNano;
import org.spf4j.base.Throwables;
import org.spf4j.base.UncheckedExecutionException;
import org.spf4j.failsafe.RetryPolicy;
import org.spf4j.recyclable.ObjectBorrowException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.RecyclingSupplier;

public final class Template<T, R, E extends Exception> {
    private final RecyclingSupplier<T> pool;
    private final Class<E> exClass;
    private final RetryPolicy<R, Callable<? extends R>> retryPolicy;

    public Template(RecyclingSupplier<T> pool, RetryPolicy<R, Callable<? extends R>> retryPolicy, Class<E> exClass) {
        this.pool = pool;
        this.exClass = exClass;
        this.retryPolicy = retryPolicy;
    }

    public R doOnSupplied(HandlerNano<T, R, E> handler, long timeout, TimeUnit tu) throws InterruptedException, E, TimeoutException {
        return Template.doOnSupplied(handler, timeout, tu, this.pool, this.retryPolicy, this.exClass);
    }

    public static <T, R, E extends Exception> R doOnSupplied(final HandlerNano<T, R, E> handler, long timeout, TimeUnit tu, final RecyclingSupplier<T> pool, RetryPolicy<R, Callable<? extends R>> retryPolicy, final Class<E> exClass) throws E, InterruptedException, TimeoutException {
        try (final ExecutionContext ctx = ExecutionContexts.start(handler.toString(), timeout, tu);){
            Object r = retryPolicy.call(new Callable<R>(){

                @Override
                public R call() throws InterruptedException, TimeoutException, Exception {
                    try {
                        return Template.doOnSupplied(handler, pool, ctx.getDeadlineNanos(), exClass);
                    }
                    catch (ObjectBorrowException | ObjectCreationException ex) {
                        throw new UncheckedExecutionException(ex);
                    }
                }
            }, exClass, ctx.getDeadlineNanos());
            return r;
        }
    }

    @SuppressFBWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"})
    private static <T, R, E extends Exception> R doOnSupplied(HandlerNano<T, R, E> handler, RecyclingSupplier<T> pool, long deadlineNanos, Class<E> exClass) throws E, ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException {
        R result;
        T object = pool.get();
        try {
            result = handler.handle(object, deadlineNanos);
        }
        catch (RuntimeException e) {
            try {
                pool.recycle(object, e);
            }
            catch (RuntimeException ex) {
                Throwables.suppressLimited(ex, e);
                throw ex;
            }
            throw e;
        }
        catch (Exception e) {
            try {
                pool.recycle(object, e);
            }
            catch (RuntimeException ex) {
                Throwables.suppressLimited(ex, e);
                throw ex;
            }
            if (exClass.isAssignableFrom(e.getClass())) {
                throw e;
            }
            throw new UncheckedExecutionException(e);
        }
        pool.recycle(object, null);
        return result;
    }

    public String toString() {
        return "Template{pool=" + this.pool + ", exClass=" + this.exClass + ", retryPolicy=" + this.retryPolicy + '}';
    }
}

