/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import java.lang.ref.Reference;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.spf4j.base.ReferenceType;
import org.spf4j.recyclable.NonValidatingRecyclingSupplier;

public final class CollectableThreadLocalRecyclingSupplier<T>
implements NonValidatingRecyclingSupplier<T> {
    private final Supplier<T> supplier;
    private final ThreadLocal<Reference<T>> threadLocal;
    private final ReferenceType refType;

    public CollectableThreadLocalRecyclingSupplier(final ReferenceType refType, final Supplier<T> supplier) {
        this.supplier = supplier;
        this.refType = refType;
        this.threadLocal = new ThreadLocal<Reference<T>>(){

            @Override
            protected Reference<T> initialValue() {
                return refType.create(supplier.get());
            }
        };
    }

    @Override
    @Nonnull
    public T get() {
        Reference<T> obj = this.threadLocal.get();
        if (obj == null) {
            return this.supplier.get();
        }
        this.threadLocal.set(null);
        T result = obj.get();
        if (result == null) {
            return this.supplier.get();
        }
        return result;
    }

    @Override
    public void recycle(T object) {
        this.threadLocal.set(this.refType.create(object));
    }

    public String toString() {
        return "CollectableThreadLocalRecyclingSupplier{supplier=" + this.supplier + ", threadLocal=" + this.threadLocal + ", refType=" + (Object)((Object)this.refType) + '}';
    }
}

