/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.spf4j.base.Either;
import org.spf4j.recyclable.ObjectBorower;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.Scanable;
import org.spf4j.recyclable.SmartRecyclingSupplier;
import org.spf4j.recyclable.impl.ObjectHolder;

final class LocalObjectPool<T>
implements RecyclingSupplier<T>,
ObjectBorower<ObjectHolder<T>> {
    private static final Either<ObjectBorower.Action, ObjectHolder<?>> REQ_MADE = Either.left(ObjectBorower.Action.REQUEST_MADE);
    private static final Either<ObjectBorower.Action, ObjectHolder<?>> NONE = Either.left(ObjectBorower.Action.NONE);
    private final Queue<ObjectHolder<T>> localObjects = new LinkedList<ObjectHolder<T>>();
    private final Map<T, ObjectHolder<T>> borrowedObjects = new HashMap<T, ObjectHolder<T>>();
    private final SmartRecyclingSupplier<ObjectHolder<T>> globalPool;
    private int reqReturnObjects;
    private final Thread thread;
    private final ReentrantLock lock;

    LocalObjectPool(SmartRecyclingSupplier<ObjectHolder<T>> globalPool) {
        this.globalPool = globalPool;
        this.reqReturnObjects = 0;
        this.thread = Thread.currentThread();
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T tryGet(long deadlineNanos) throws ObjectCreationException, InterruptedException {
        this.lock.lock();
        try {
            ObjectHolder<T> objectHolder;
            T object;
            do {
                if (this.localObjects.isEmpty()) {
                    objectHolder = this.globalPool.tryGet(this, deadlineNanos);
                    if (objectHolder != null) continue;
                    T t = null;
                    return t;
                }
                objectHolder = this.localObjects.remove();
            } while ((object = objectHolder.borrowOrCreateObjectIfPossible()) == null);
            this.borrowedObjects.put(object, objectHolder);
            T t = object;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(T object, Exception e) {
        block9: {
            this.lock.lock();
            try {
                ObjectHolder<T> holder = this.borrowedObjects.remove(object);
                if (holder == null) {
                    this.globalPool.recycle(new ObjectHolder<T>(object, this.globalPool.getSample().getFactory()), this);
                    break block9;
                }
                try {
                    holder.returnObject(object, e);
                }
                finally {
                    if (this.reqReturnObjects > 0) {
                        --this.reqReturnObjects;
                        this.globalPool.recycle(holder, this);
                    } else {
                        this.localObjects.add(holder);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public boolean tryDispose(long timeoutMillis) {
        throw new UnsupportedOperationException("LocalPool dispose is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scan(Scanable.ScanHandler<ObjectHolder<T>> handler) throws Exception {
        this.lock.lock();
        try {
            for (ObjectHolder objectHolder : this.localObjects) {
                if (handler.handle(objectHolder)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Either<ObjectBorower.Action, ObjectHolder<T>> tryRequestReturnObject() throws InterruptedException {
        boolean acquired = this.lock.tryLock(0L, TimeUnit.SECONDS);
        if (acquired) {
            try {
                Object objectHolder = this.tryReturnObjectIfNotInUse();
                if (objectHolder != null) {
                    Either either = Either.right(objectHolder);
                    return either;
                }
                if (this.thread == Thread.currentThread()) {
                    if (this.borrowedObjects.isEmpty()) {
                        Either<ObjectBorower.Action, ObjectHolder<T>> either = NONE;
                        return either;
                    }
                    Iterator<Map.Entry<T, ObjectHolder<T>>> it = this.borrowedObjects.entrySet().iterator();
                    Map.Entry<T, ObjectHolder<T>> next = it.next();
                    ObjectHolder<T> result = next.getValue();
                    result.returnObject(next.getKey(), null);
                    it.remove();
                    Either<ObjectBorower.Action, ObjectHolder<T>> either = Either.right(result);
                    return either;
                }
                if (this.borrowedObjects.size() > this.reqReturnObjects) {
                    ++this.reqReturnObjects;
                    Either<ObjectBorower.Action, ObjectHolder<T>> either = REQ_MADE;
                    return either;
                }
                Either<ObjectBorower.Action, ObjectHolder<T>> either = NONE;
                return either;
            }
            finally {
                this.lock.unlock();
            }
        }
        return NONE;
    }

    @Override
    @Nullable
    public ObjectHolder<T> tryReturnObjectIfNotInUse() throws InterruptedException {
        boolean acquired = this.lock.tryLock(0L, TimeUnit.SECONDS);
        if (acquired) {
            try {
                if (!this.localObjects.isEmpty()) {
                    ObjectHolder<T> objectHolder = this.localObjects.remove();
                    return objectHolder;
                }
                ObjectHolder<T> objectHolder = null;
                return objectHolder;
            }
            finally {
                this.lock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ObjectHolder<T>> tryReturnObjectsIfNotInUse() throws InterruptedException {
        boolean acquired = this.lock.tryLock(0L, TimeUnit.SECONDS);
        if (acquired) {
            try {
                if (!this.localObjects.isEmpty()) {
                    ArrayList<ObjectHolder<T>> result = new ArrayList<ObjectHolder<T>>(this.localObjects);
                    this.localObjects.clear();
                    ArrayList<ObjectHolder<T>> arrayList = result;
                    return arrayList;
                }
                List list = Collections.EMPTY_LIST;
                return list;
            }
            finally {
                this.lock.unlock();
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Collection<ObjectHolder<T>> tryReturnObjectsIfNotNeededAnymore() throws InterruptedException {
        boolean acquired = this.lock.tryLock(0L, TimeUnit.SECONDS);
        if (acquired) {
            try {
                if (!this.thread.isAlive()) {
                    if (!this.borrowedObjects.isEmpty()) {
                        throw new IllegalStateException("Objects not returned by dead thread: " + this.borrowedObjects);
                    }
                    Queue<ObjectHolder<T>> queue = this.localObjects;
                    return queue;
                }
                List list = Collections.EMPTY_LIST;
                return list;
            }
            finally {
                this.lock.unlock();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public String toString() {
        return "LocalObjectPool{localObjects=" + this.localObjects + ", borrowedObjects=" + this.borrowedObjects + ", reqReturnObjects=" + this.reqReturnObjects + ", thread=" + this.thread + '}';
    }

    @Override
    public void recycle(T object) {
        this.recycle(object, null);
    }

    @Override
    public boolean nevermind(ObjectHolder<T> object) {
        this.lock.lock();
        try {
            boolean bl = this.borrowedObjects.remove(object.getObj()) != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

