/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.Scanable;
import org.spf4j.recyclable.impl.LocalObjectPool;
import org.spf4j.recyclable.impl.ObjectHolder;
import org.spf4j.recyclable.impl.ObjectHolderFactory;
import org.spf4j.recyclable.impl.SimpleSmartObjectPool;

@SuppressFBWarnings(value={"PMB_INSTANCE_BASED_THREAD_LOCAL"})
final class ScalableObjectPool<T>
implements RecyclingSupplier<T>,
Scanable<ObjectHolder<T>> {
    private final SimpleSmartObjectPool<ObjectHolder<T>> globalPool;
    private final ThreadLocal<LocalObjectPool<T>> localPool;

    ScalableObjectPool(int initialSize, int maxSize, @Nonnull RecyclingSupplier.Factory<T> factory, boolean fair) throws ObjectCreationException {
        this.globalPool = new SimpleSmartObjectPool<T>(initialSize, maxSize, new ObjectHolderFactory<T>(initialSize, factory), fair);
        this.localPool = new ThreadLocal<LocalObjectPool<T>>(){

            @Override
            protected LocalObjectPool<T> initialValue() {
                return new LocalObjectPool(ScalableObjectPool.this.globalPool);
            }
        };
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"AI_ANNOTATION_ISSUES_NEEDS_NULLABLE"})
    public T tryGet(long deadlineNanos) throws ObjectCreationException, InterruptedException {
        return this.localPool.get().tryGet(deadlineNanos);
    }

    @Override
    public void recycle(T object, Exception e) {
        this.localPool.get().recycle(object, e);
    }

    @Override
    public boolean tryDispose(long timeoutMillis) throws ObjectDisposeException, InterruptedException {
        return this.globalPool.tryDispose(timeoutMillis);
    }

    @Override
    public boolean scan(Scanable.ScanHandler<ObjectHolder<T>> handler) throws Exception {
        return this.globalPool.scan(handler);
    }

    public void requestReturnFromBorrowersIfNotInUse() throws InterruptedException {
        this.globalPool.requestReturnFromBorrowersIfNotInUse();
    }

    public String toString() {
        return "ScalableObjectPool{globalPool=" + this.globalPool + '}';
    }

    @Override
    public void recycle(T object) {
        this.recycle(object, null);
    }
}

