/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import com.google.common.collect.LinkedHashMultimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.spf4j.base.Either;
import org.spf4j.base.Pair;
import org.spf4j.base.Throwables;
import org.spf4j.base.TimeSource;
import org.spf4j.recyclable.ObjectBorower;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.Scanable;
import org.spf4j.recyclable.SmartRecyclingSupplier;

final class SimpleSmartObjectPool<T>
implements SmartRecyclingSupplier<T> {
    private int maxSize;
    private int waitingForReturn;
    private final LinkedHashMultimap<ObjectBorower<T>, T> borrowedObjects;
    private final List<T> availableObjects;
    private final ReentrantLock lock;
    private final Condition available;
    private final RecyclingSupplier.Factory<T> factory;
    private T sample;

    SimpleSmartObjectPool(int initialSize, int maxSize, RecyclingSupplier.Factory<T> factory, boolean fair) throws ObjectCreationException {
        if (maxSize < 1) {
            throw new IllegalArgumentException("Invalid pool size: " + maxSize);
        }
        this.maxSize = maxSize;
        this.factory = factory;
        this.lock = new ReentrantLock(fair);
        this.available = this.lock.newCondition();
        this.borrowedObjects = LinkedHashMultimap.create();
        this.availableObjects = new ArrayList<T>(initialSize);
        for (int i = 0; i < initialSize; ++i) {
            this.availableObjects.add(factory.create());
        }
        this.waitingForReturn = 0;
        this.sample = factory.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", "PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public T tryGet(ObjectBorower borower, long deadlineNanos) throws InterruptedException, ObjectCreationException {
        this.lock.lock();
        try {
            T t;
            if (this.maxSize <= 0) {
                throw new IllegalStateException("Pool closed, noting available for " + borower);
            }
            int nrAvailable = this.availableObjects.size();
            if (nrAvailable - this.waitingForReturn > 0) {
                Iterator<T> it = this.availableObjects.iterator();
                T object2 = it.next();
                it.remove();
                if (!this.borrowedObjects.put((Object)borower, object2)) {
                    throw new IllegalStateException("Cannot borrow " + object2 + ", " + this.borrowedObjects);
                }
                T t2 = object2;
                return t2;
            }
            if (this.borrowedObjects.size() + nrAvailable < this.maxSize) {
                T object = this.factory.create();
                if (!this.borrowedObjects.put((Object)borower, object)) {
                    throw new IllegalStateException("Cannot borrow " + object + ", " + this.borrowedObjects);
                }
                T object2 = object;
                return object2;
            }
            for (ObjectBorower b : this.borrowedObjects.keySet()) {
                Object object;
                if (borower == b || (object = b.tryReturnObjectIfNotInUse()) == null) continue;
                if (!this.borrowedObjects.remove((Object)b, object)) {
                    throw new IllegalStateException("Returned Object hasn't been borrowed " + object);
                }
                if (!this.borrowedObjects.put((Object)borower, object)) {
                    throw new IllegalStateException("Cannot borrow " + object + ", " + this.borrowedObjects);
                }
                Object t3 = object;
                return t3;
            }
            boolean requestMade = false;
            while (!requestMade) {
                boolean hasValidBorowers = false;
                for (ObjectBorower b : this.borrowedObjects.keySet()) {
                    if (borower == b) continue;
                    hasValidBorowers = true;
                    Either objOrPromise = b.tryRequestReturnObject();
                    if (objOrPromise.isRight()) {
                        Object obj = objOrPromise.getRight();
                        if (!this.borrowedObjects.remove((Object)b, obj)) {
                            throw new IllegalStateException("Returned Object " + obj + " hasn't been borrowed: " + this.borrowedObjects);
                        }
                        if (!this.borrowedObjects.put((Object)borower, obj)) {
                            throw new IllegalStateException("Cannot boroow " + obj + ", " + this.borrowedObjects);
                        }
                        Object t4 = obj;
                        return t4;
                    }
                    requestMade = objOrPromise.getLeft() == ObjectBorower.Action.REQUEST_MADE;
                    if (!requestMade) continue;
                    break;
                }
                if (!hasValidBorowers) {
                    throw new IllegalStateException("Borrower asks for more than possible " + borower);
                }
                if (requestMade) continue;
                do {
                    this.available.await(1L, TimeUnit.MILLISECONDS);
                    long nanosToDeadline = deadlineNanos - TimeSource.nanoTime();
                    if (nanosToDeadline >= 0L) continue;
                    T t5 = null;
                    return t5;
                } while (this.borrowedObjects.isEmpty());
            }
            ++this.waitingForReturn;
            while (this.availableObjects.isEmpty()) {
                long waitTime = deadlineNanos - TimeSource.nanoTime();
                if (waitTime <= 0L) {
                    t = null;
                    return t;
                }
                if (this.available.await(waitTime, TimeUnit.NANOSECONDS)) continue;
                t = null;
                return t;
            }
            --this.waitingForReturn;
            Iterator<T> it = this.availableObjects.iterator();
            T objectT = it.next();
            it.remove();
            if (!this.borrowedObjects.put((Object)borower, objectT)) {
                throw new IllegalStateException("Cannot borrow " + objectT + ", " + this.borrowedObjects);
            }
            t = objectT;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(T object, ObjectBorower borower) {
        this.lock.lock();
        try {
            if (!this.borrowedObjects.remove((Object)borower, object)) {
                Map.Entry foundEntry = null;
                for (Map.Entry entry : this.borrowedObjects.entries()) {
                    ObjectBorower lb = (ObjectBorower)entry.getKey();
                    if (lb == borower || !lb.nevermind(entry.getValue())) continue;
                    foundEntry = entry;
                    break;
                }
                if (foundEntry == null) {
                    throw new IllegalStateException("Object " + object + " has not been borrowed from this pool");
                }
                if (!this.borrowedObjects.remove(foundEntry.getKey(), foundEntry.getValue())) {
                    throw new IllegalStateException("Should have removed " + foundEntry);
                }
            }
            this.availableObjects.add(object);
            this.available.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean tryDispose(long timeoutMillis) throws ObjectDisposeException, InterruptedException {
        this.factory.dispose(this.sample);
        long deadlineNanos = TimeSource.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
        this.lock.lock();
        try {
            this.maxSize = 0;
            ArrayList returnedObjects = new ArrayList();
            for (Map.Entry entry : this.borrowedObjects.asMap().entrySet()) {
                ObjectBorower borrower = (ObjectBorower)entry.getKey();
                int nrObjects = ((Collection)entry.getValue()).size();
                for (int i = 0; i < nrObjects; ++i) {
                    Either object = borrower.tryRequestReturnObject();
                    if (!object.isRight()) continue;
                    returnedObjects.add(Pair.of(borrower, object.getRight()));
                }
            }
            for (Pair bl : returnedObjects) {
                Object object = bl.getSecond();
                if (!this.borrowedObjects.remove(bl.getFirst(), object)) {
                    throw new IllegalStateException("Returned Object hasn't been borrowed " + object);
                }
                this.availableObjects.add(object);
            }
            ObjectDisposeException exception = this.disposeReturnedObjects(null);
            while (!this.borrowedObjects.isEmpty()) {
                boolean bl;
                long l = deadlineNanos - TimeSource.nanoTime();
                if (l <= 0L) {
                    bl = false;
                    return bl;
                }
                if (!this.available.await(l, TimeUnit.NANOSECONDS)) {
                    bl = false;
                    return bl;
                }
                exception = this.disposeReturnedObjects(exception);
            }
            if (exception != null) {
                throw exception;
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException | RuntimeException e) {
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @CheckReturnValue
    private ObjectDisposeException disposeReturnedObjects(ObjectDisposeException exception) {
        ObjectDisposeException result = exception;
        for (T obj : this.availableObjects) {
            try {
                this.factory.dispose(obj);
            }
            catch (ObjectDisposeException ex) {
                if (result != null) {
                    Throwables.suppressLimited(ex, result);
                }
                result = ex;
            }
            catch (Exception ex) {
                if (result == null) {
                    result = new ObjectDisposeException(ex);
                    continue;
                }
                ObjectDisposeException nex = new ObjectDisposeException(ex);
                Throwables.suppressLimited(nex, result);
                result = nex;
            }
        }
        this.availableObjects.clear();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_HAS_CHECKED"})
    public boolean scan(Scanable.ScanHandler<T> handler) throws Exception {
        this.lock.lock();
        Exception resEx = null;
        try {
            for (ObjectBorower objectBorower : this.borrowedObjects.keySet()) {
                try {
                    if (!objectBorower.scan(handler)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (Exception e) {
                    if (resEx != null) {
                        Throwables.suppressLimited(e, resEx);
                    }
                    resEx = e;
                }
                Collection returned = objectBorower.tryReturnObjectsIfNotNeededAnymore();
                for (Object ro : returned) {
                    if (!this.borrowedObjects.remove((Object)objectBorower, ro)) {
                        throw new IllegalStateException("Object returned hasn't been borrowed" + ro);
                    }
                    this.availableObjects.add(ro);
                }
            }
            for (Object object : this.availableObjects) {
                try {
                    if (handler.handle(object)) continue;
                    boolean returned = false;
                    return returned;
                }
                catch (Exception e) {
                    if (resEx != null) {
                        Throwables.suppressLimited(e, resEx);
                    }
                    resEx = e;
                }
            }
            if (resEx != null) {
                throw resEx;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public void requestReturnFromBorrowersIfNotInUse() throws InterruptedException {
        this.lock.lock();
        try {
            ArrayList returnedObjects = new ArrayList();
            for (ObjectBorower objectBorower : this.borrowedObjects.keySet()) {
                Collection objects = objectBorower.tryReturnObjectsIfNotInUse();
                for (Object object : objects) {
                    returnedObjects.add(Pair.of(objectBorower, object));
                }
            }
            for (Pair pair : returnedObjects) {
                Object object = pair.getSecond();
                this.borrowedObjects.remove(pair.getFirst(), object);
                this.availableObjects.add(object);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        this.lock.lock();
        try {
            String string = "SimpleSmartObjectPool{maxSize=" + this.maxSize + ", borrowedObjects=" + this.borrowedObjects + ", availableObjects=" + this.availableObjects + ", factory=" + this.factory + '}';
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T getSample() {
        return this.sample;
    }
}

