/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.reflect;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.concurrent.UnboundedLoadingCache;
import org.spf4j.reflect.TypeMap;

@ThreadSafe
public final class CachingTypeMapWrapper<H>
implements TypeMap<H> {
    private final LoadingCache<Type, Set<H>> cache;
    @GuardedBy(value="syncObj")
    private final TypeMap<H> wrapped;
    private final Object syncObj = new Object();

    public CachingTypeMapWrapper(CacheBuilder<Type, Set<H>> cacheBuilder, TypeMap wrapped) {
        this.wrapped = wrapped;
        this.cache = cacheBuilder.build((CacheLoader)new TypeMapedObjLoader());
    }

    public CachingTypeMapWrapper(TypeMap wrapped) {
        this.wrapped = wrapped;
        this.cache = new UnboundedLoadingCache<Type, Set<H>>(16, new TypeMapedObjLoader());
    }

    @Override
    public Set<H> getAll(Type t) {
        return (Set)this.cache.getUnchecked((Object)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putIfNotPresent(Type type, H appender) {
        Object object = this.syncObj;
        synchronized (object) {
            return this.wrapped.putIfNotPresent(type, appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Type type) {
        boolean remove;
        Object object = this.syncObj;
        synchronized (object) {
            remove = this.wrapped.remove(type);
        }
        if (remove) {
            this.cache.invalidateAll();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public H getExact(Type t) {
        TypeMap<H> typeMap = this.wrapped;
        synchronized (typeMap) {
            return this.wrapped.getExact(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Type t, Function<H, H> f) {
        TypeMap<H> typeMap = this.wrapped;
        synchronized (typeMap) {
            H exact = this.wrapped.getExact(t);
            if (exact != null && !this.wrapped.remove(t)) {
                throw new IllegalStateException("Illegal Stat, type = " + t + " wrapped =  " + this.wrapped);
            }
            this.wrapped.safePut(t, f.apply(exact));
        }
        this.cache.invalidateAll();
    }

    public void clearCache() {
        this.cache.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String wts;
        TypeMap<H> typeMap = this.wrapped;
        synchronized (typeMap) {
            wts = this.wrapped.toString();
        }
        return "CachingTypeMapWrapper{cache=" + this.cache + ", wrapped=" + wts + '}';
    }

    private final class TypeMapedObjLoader
    extends CacheLoader<Type, Set<H>> {
        private TypeMapedObjLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<H> load(Type key) throws Exception {
            TypeMap typeMap = CachingTypeMapWrapper.this.wrapped;
            synchronized (typeMap) {
                return CachingTypeMapWrapper.this.wrapped.getAll(key);
            }
        }
    }
}

