/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.reflect;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.reflect.TypeToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spf4j.ds.Graphs;
import org.spf4j.reflect.TypeMap;

public final class GraphTypeMap<H>
implements TypeMap<H> {
    private final MutableGraph<TypeToken> typeGraph;
    private final Map<TypeToken, H> handlers;

    public GraphTypeMap() {
        this(16);
    }

    public GraphTypeMap(int expectedSize) {
        this.typeGraph = GraphBuilder.directed().allowsSelfLoops(false).expectedNodeCount(expectedSize).build();
        this.handlers = new HashMap<TypeToken, H>(expectedSize);
    }

    @Override
    public Set<H> getAll(Type t) {
        HashSet<H> result = new HashSet<H>(1);
        TypeToken tt = TypeToken.of((Type)t);
        MutableGraph<TypeToken> traverseGraph = Graphs.clone(this.typeGraph);
        Set nodes = traverseGraph.nodes();
        ArrayList<TypeToken> nodesToRemove = new ArrayList<TypeToken>();
        do {
            for (TypeToken token : nodes) {
                if (traverseGraph.inDegree((Object)token) != 0) continue;
                nodesToRemove.add(token);
                if (!tt.isSubtypeOf(token)) continue;
                result.add(this.handlers.get(token));
            }
            for (TypeToken token : nodesToRemove) {
                if (traverseGraph.removeNode((Object)token)) continue;
                throw new IllegalStateException("Cannot remove " + token + " from " + traverseGraph);
            }
            nodesToRemove.clear();
            nodes = traverseGraph.nodes();
        } while (result.isEmpty() && !nodes.isEmpty());
        return result;
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public boolean putIfNotPresent(Type type, H appender) {
        TypeToken nType = TypeToken.of((Type)type);
        if (this.typeGraph.addNode((Object)nType)) {
            this.handlers.put(nType, appender);
            for (TypeToken t : this.typeGraph.nodes()) {
                if (nType.equals((Object)t)) continue;
                if (nType.isSubtypeOf(t)) {
                    this.typeGraph.putEdge((Object)nType, (Object)t);
                    continue;
                }
                if (!t.isSubtypeOf(nType)) continue;
                this.typeGraph.putEdge((Object)t, (Object)nType);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Type type) {
        TypeToken tt = TypeToken.of((Type)type);
        if (this.typeGraph.removeNode((Object)tt)) {
            this.handlers.remove(tt);
            return true;
        }
        return false;
    }

    public String toString() {
        return "GraphTypeMap{typeGraph=" + this.typeGraph + ", handlers=" + this.handlers + '}';
    }

    @Override
    public H getExact(Type t) {
        return this.handlers.get(TypeToken.of((Type)t));
    }
}

