/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.reflect;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Type;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.reflect.ByTypeSupplier;

@ParametersAreNonnullByDefault
public interface TypeMap<H>
extends ByTypeSupplier<H, RuntimeException> {
    @Nonnull
    public Set<H> getAll(Type var1);

    @Override
    @Nullable
    @SuppressFBWarnings(value={"SPP_USE_ISEMPTY"})
    default public H get(Type t) {
        Set<H> get = this.getAll(t);
        int size = get.size();
        if (size == 1) {
            return get.iterator().next();
        }
        if (size == 0) {
            return null;
        }
        throw new IllegalArgumentException("Ambiguous handlers " + get + " for " + t + " in  " + this);
    }

    @Nullable
    public H getExact(Type var1);

    @CheckReturnValue
    public boolean putIfNotPresent(Type var1, H var2);

    default public TypeMap<H> safePut(Type type, H object) {
        if (!this.putIfNotPresent(type, object)) {
            throw new IllegalArgumentException("Cannot put " + type + ", " + object + " exiting mapping present");
        }
        return this;
    }

    @CheckReturnValue
    public boolean remove(Type var1);
}

